/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.api;

import com.perforce.api.Debug;
import com.perforce.api.Env;
import com.perforce.api.FileEntry;
import com.perforce.api.HashDecay;
import com.perforce.api.P4Process;
import com.perforce.api.SourceControlObject;
import java.io.IOException;
import java.util.Vector;

public final class DirEntry
extends SourceControlObject {
    private String path;
    private DirEntry parent;
    private boolean opened = false;
    private Vector subdirs = new Vector();
    private Vector files = new Vector();
    private static HashDecay dirs = null;

    public DirEntry() {
        DirEntry.setCache();
    }

    public DirEntry(Env e) {
        this();
        this.setEnv(e);
    }

    public DirEntry(Env e, String path) {
        this(e);
        this.setPath(path);
    }

    public DirEntry(DirEntry base, String path) {
        this();
        this.setEnv(base.getEnv());
        this.setPath(path);
    }

    public void sync() {
        try {
            this.loadDirs(this.getEnv());
            this.loadFiles(this.getEnv(), this.path);
            this.inSync();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void commit() {
    }

    private static HashDecay setCache() {
        if (null == dirs) {
            dirs = new HashDecay(120000L);
            dirs.start();
        }
        return dirs;
    }

    public HashDecay getCache() {
        return DirEntry.setCache();
    }

    public static DirEntry getDirEntry(Env env, String path, boolean sync) {
        if (null == path || path.trim().equals("")) {
            return null;
        }
        DirEntry de = (DirEntry)DirEntry.setCache().get(path);
        if (null == de) {
            de = new DirEntry(env, path);
        }
        if (null != env) {
            de.setEnv(env);
        }
        if (sync) {
            de.sync();
        }
        dirs.put((Object)path, de);
        return de;
    }

    public void setPath(String path) {
        if (null == path) {
            return;
        }
        if ((path = path.trim()).equals("") || !path.startsWith("//")) {
            return;
        }
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public String getBasePath() {
        int pos = this.path.lastIndexOf(47);
        if (-1 == pos) {
            return "//";
        }
        return this.path.substring(0, pos + 1);
    }

    public DirEntry getParent() {
        DirEntry parent = null;
        int pos = this.path.lastIndexOf(47);
        if (-1 == pos) {
            return null;
        }
        String parent_path = this.path.substring(0, pos);
        if (parent_path.equals("/")) {
            return null;
        }
        if (null == parent) {
            parent = new DirEntry(this, parent_path);
        }
        return parent;
    }

    public String[] getDirNames() {
        return this.getDirNames(this.getEnv());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDirNames(Env env) {
        String[] names;
        this.loadDirs(env);
        Vector vector = this.subdirs;
        synchronized (vector) {
            names = this.v2a(this.subdirs);
        }
        return names;
    }

    private void loadDirs() {
        this.loadDirs(this.getEnv());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDirs(Env env) {
        if (!this.outOfSync(60000L)) {
            return;
        }
        String[] cmd = new String[]{"p4", "dirs", this.path + "%1"};
        Vector vector = this.subdirs;
        synchronized (vector) {
            this.subdirs.removeAllElements();
        }
        try {
            String l;
            P4Process p = new P4Process(env);
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                if (!l.startsWith("//") || -1 != l.indexOf(" - ")) continue;
                String dir = l.trim();
                int pos = dir.lastIndexOf(47);
                if (-1 != pos) {
                    dir = dir.substring(pos + 1).trim();
                }
                Vector vector2 = this.subdirs;
                synchronized (vector2) {
                    this.subdirs.addElement(dir);
                }
            }
            p.close();
        }
        catch (IOException ex) {
            Debug.out(1, ex);
        }
    }

    private String[] v2a(Vector v) {
        String[] tmp = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            tmp[i] = (String)v.elementAt(i);
        }
        return tmp;
    }

    public FileEntry[] getFiles() {
        return this.getFiles(this.getEnv());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEntry[] getFiles(Env env) {
        FileEntry[] tmp;
        this.loadFiles(env, this.path);
        if (null == this.files) {
            return null;
        }
        Vector vector = this.files;
        synchronized (vector) {
            tmp = new FileEntry[this.files.size()];
            for (int i = 0; i < this.files.size(); ++i) {
                tmp[i] = (FileEntry)this.files.elementAt(i);
                tmp[i].setEnv(env);
            }
        }
        return tmp;
    }

    public String[] getFileNames() {
        return this.getFileNames(this.getEnv());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getFileNames(Env env) {
        String[] names;
        this.loadFiles(env, this.path);
        if (null == this.files) {
            String[] names2 = new String[]{""};
            return names2;
        }
        Vector vector = this.files;
        synchronized (vector) {
            names = new String[this.files.size()];
            for (int i = 0; i < this.files.size(); ++i) {
                names[i] = ((FileEntry)this.files.elementAt(i)).getName();
            }
        }
        return names;
    }

    private void loadFiles() {
        this.loadFiles(this.getEnv(), this.path);
    }

    private void loadFiles(Env env, String path) {
        if (!this.outOfSync(60000L)) {
            return;
        }
        this.files = FileEntry.getFiles(env, path);
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer("<dir path=\"");
        sb.append(this.getPath());
        sb.append("\"/>");
        return sb.toString();
    }
}

