/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce.parse;

import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Group;
import com.tek42.perforce.parse.AbstractFormBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupBuilder
extends AbstractFormBuilder<Group> {
    public Group buildForm(Map<String, String> fields) throws PerforceException {
        Group group = new Group();
        group.setName(this.getField("Group", fields));
        group.setMaxLockTime(this.getField("MaxLockTime", fields));
        group.setMaxResults(this.getField("MaxResults", fields));
        group.setMaxScanRows(this.getField("MaxScanRows", fields));
        String value = this.getField("Timeout", fields);
        if (value.equals("")) {
            value = "0";
        }
        group.setTimeout(Long.valueOf(Long.parseLong(value)));
        group.setUsers(this.getFieldAsList("Users", fields));
        group.setSubgroups(this.getFieldAsList("Subgroups", fields));
        group.setOwners(this.getFieldAsList("Owners", fields));
        return group;
    }

    public String[] getBuildCmd(String id) {
        return new String[]{"p4", "group", "-o", id};
    }

    public String[] getSaveCmd(Group obj) {
        return new String[]{"p4", "-s", "group", "-i"};
    }

    public void save(Group group, Writer out) throws PerforceException {
        if (group.getOwnersAsString().equals("")) {
            throw new IllegalArgumentException("Group owner is a required field.");
        }
        try {
            out.write("Group: " + group.getName() + "\n");
            out.write("MaxResults: " + group.getMaxResults() + "\n");
            out.write("MaxScanRows: " + group.getMaxScanRows() + "\n");
            out.write("MaxLockTime: " + group.getMaxLockTime() + "\n");
            out.write("Timeout: " + group.getTimeout() + "\n");
            out.write("Subgroups:\n");
            for (String s : group.getSubgroups()) {
                out.write(" " + s + "\n");
            }
            out.write("Owners:\n");
            for (String s : group.getOwners()) {
                out.write(" " + s + "\n");
            }
            out.write("Users:\n");
            for (String s : group.getUsers()) {
                out.write(" " + s + "\n");
            }
        }
        catch (IOException e) {
            throw new PerforceException("Failed to save group: " + group.getName(), (Throwable)e);
        }
    }
}

