/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce.parse;

import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Label;
import com.tek42.perforce.parse.AbstractFormBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelBuilder
extends AbstractFormBuilder<Label> {
    public Label buildForm(Map<String, String> fields) throws PerforceException {
        Label label = new Label();
        label.setName(fields.get("Label"));
        label.setAccess(this.getField("Access", fields));
        label.setUpdate(this.getField("Update", fields));
        label.setDescription(this.getField("Description", fields));
        label.setOptions(this.getField("Options", fields));
        label.setOwner(this.getField("Owner", fields));
        label.setRevision(this.getField("Revision", fields));
        String views = this.getField("View", fields);
        for (String view : views.split("\n")) {
            label.addView(view);
        }
        return label;
    }

    public String[] getBuildCmd(String id) {
        return new String[]{"p4", "label", "-o", id};
    }

    public String[] getSaveCmd(Label obj) {
        return new String[]{"p4", "-s", "label", "-i"};
    }

    public void save(Label label, Writer writer) throws PerforceException {
        try {
            writer.write("Label: " + label.getName() + "\n");
            writer.write("Owner: " + label.getOwner() + "\n");
            writer.write("Description:\n\t" + label.getDescription() + "\n");
            writer.write("Revision: " + label.getRevision() + "\n");
            writer.write("Options: " + label.getOptions() + "\n");
            writer.write("View:\n");
            for (String view : label.getViews()) {
                writer.write("\t" + view + "\n");
            }
            writer.write("\n");
        }
        catch (IOException e) {
            throw new PerforceException("Failed to save label", (Throwable)e);
        }
    }
}

