/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce.parse;

import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import com.tek42.perforce.parse.AbstractPerforceTemplate;
import com.tek42.perforce.parse.Builder;
import com.tek42.perforce.process.Executor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPerforceTemplate {
    private static final String[] p4errors = new String[]{"Connect to server failed; check $P4PORT", "Perforce password (P4PASSWD) invalid or unset.", "Password not allowed at this server security level, use 'p4 login'", "Can't create a new user - over license quota.", "Client '*' can only be used from host '*'", "Access for user '", "Your session has expired, please login again."};
    private transient Logger logger;
    private transient String[] errors;
    private final Depot depot;
    final String maxError = "Request too large";

    public AbstractPerforceTemplate(Depot depot) {
        this.depot = depot;
    }

    public Logger getLogger() {
        return this.depot.getLogger();
    }

    protected List<String> parseList(StringBuilder response, int index) {
        StringTokenizer lines = new StringTokenizer(response.toString(), "\n\r");
        ArrayList<String> list = new ArrayList<String>(100);
        while (lines.hasMoreElements()) {
            StringTokenizer columns = new StringTokenizer(lines.nextToken());
            for (int column = 0; column < index; ++column) {
                columns.nextToken();
            }
            list.add(columns.nextToken());
        }
        return list;
    }

    protected boolean hitMax(StringBuilder response) {
        return response.toString().startsWith("Request too large");
    }

    protected String[] getExtraParams(String[] cmd) {
        String ticket = this.depot.getP4Ticket();
        if (ticket != null) {
            String[] newCmds = new String[cmd.length + 2];
            newCmds[0] = "p4";
            newCmds[1] = "-P";
            newCmds[2] = ticket;
            int i = 3;
            while (i - 2 < cmd.length) {
                newCmds[i] = cmd[i - 2];
                ++i;
            }
            cmd = newCmds;
        }
        return cmd;
    }

    protected void saveToPerforce(Object object, Builder builder) throws PerforceException {
        boolean loop = false;
        boolean attemptLogin = true;
        do {
            int mesgIndex = -1;
            Executor p4 = this.depot.getExecFactory().newExecutor();
            String debugCmd = "";
            try {
                String line;
                String[] cmds;
                for (String cm : cmds = this.getExtraParams(builder.getSaveCmd(object))) {
                    debugCmd = debugCmd + cm + " ";
                }
                p4.exec(cmds);
                BufferedReader reader = p4.getReader();
                StringBuilder log = new StringBuilder();
                if (builder.requiresStandardInput()) {
                    BufferedWriter writer = p4.getWriter();
                    1 fwriter = new /* Unavailable Anonymous Inner Class!! */;
                    builder.save(object, (Writer)fwriter);
                    fwriter.flush();
                    fwriter.close();
                }
                String error = "";
                String info = "";
                int exitCode = 0;
                while ((line = reader.readLine()) != null) {
                    for (int i = 0; i < p4errors.length; ++i) {
                        if (line.indexOf(p4errors[i]) == -1) continue;
                        mesgIndex = i;
                    }
                    if (line.startsWith("error")) {
                        if (line.trim().equals("") || line.indexOf("up-to-date") >= 0 || line.indexOf("no file(s) to resolve") >= 0) continue;
                        error = error + line.substring(6);
                        continue;
                    }
                    if (line.startsWith("exit")) {
                        exitCode = Integer.parseInt(line.substring(line.indexOf(" ") + 1, line.length()));
                        continue;
                    }
                    if (line.indexOf(":") > -1) {
                        info = info + line.substring(line.indexOf(":"));
                        continue;
                    }
                    info = info + line;
                }
                reader.close();
                loop = false;
                if (attemptLogin && (mesgIndex == 1 || mesgIndex == 2 || mesgIndex == 6)) {
                    p4.close();
                    this.login();
                    loop = true;
                    attemptLogin = false;
                } else if (exitCode != 0) {
                    if (!error.equals("")) {
                        throw new PerforceException(error + "\nFor Command: " + debugCmd + "\nWith Data:\n===================\n" + log.toString() + "===================\n");
                    }
                    throw new PerforceException(info);
                }
            }
            catch (IOException e) {
                throw new PerforceException("Failed to open connection to perforce", (Throwable)e);
            }
            finally {
                p4.close();
            }
        } while (loop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBuilder getPerforceResponse(String[] cmd) throws PerforceException {
        boolean loop = false;
        boolean attemptLogin = true;
        ArrayList<String> lines = null;
        int totalLength = 0;
        do {
            int mesgIndex = -1;
            int count = 0;
            Executor p4 = this.depot.getExecFactory().newExecutor();
            String debugCmd = "";
            for (String cm : cmd = this.getExtraParams(cmd)) {
                debugCmd = debugCmd + cm + " ";
            }
            p4.exec(cmd);
            BufferedReader reader = p4.getReader();
            String line = null;
            totalLength = 0;
            lines = new ArrayList<String>(1024);
            try {
                while ((line = reader.readLine()) != null) {
                    lines.add(line);
                    totalLength += line.length();
                    ++count;
                    for (int i = 0; i < p4errors.length; ++i) {
                        if (line.indexOf(p4errors[i]) == -1) continue;
                        mesgIndex = i;
                    }
                }
            }
            catch (IOException ioe) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter((Writer)sw, true);
                ioe.printStackTrace(pw);
                pw.flush();
                sw.flush();
                this.getLogger().warn("Perforce process terminated suddenly");
                this.getLogger().warn(sw.toString());
            }
            finally {
                p4.close();
            }
            loop = false;
            if (attemptLogin && (mesgIndex == 1 || mesgIndex == 2 || mesgIndex == 6)) {
                p4.close();
                this.login();
                loop = true;
                attemptLogin = false;
                continue;
            }
            if (mesgIndex == 4) {
                throw new PerforceException("Access for user '" + this.depot.getUser() + "' has not been enabled by 'p4 protect'");
            }
            if (mesgIndex != -1) {
                throw new PerforceException(p4errors[mesgIndex]);
            }
            if (count != 0) continue;
            throw new PerforceException("No output for: " + debugCmd);
        } while (loop);
        StringBuilder response = new StringBuilder(totalLength + lines.size());
        for (String line : lines) {
            response.append(line);
            response.append("\n");
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getRawPerforceResponseLines(String[] cmd) throws PerforceException {
        ArrayList<String> lines = new ArrayList<String>(1024);
        Executor p4 = this.depot.getExecFactory().newExecutor();
        String debugCmd = "";
        for (String cm : cmd = this.getExtraParams(cmd)) {
            debugCmd = debugCmd + cm + " ";
        }
        p4.exec(cmd);
        try {
            BufferedReader reader = p4.getReader();
            String line = null;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException ioe) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            ioe.printStackTrace(pw);
            pw.flush();
            sw.flush();
            this.getLogger().warn("IOException reading from Perforce process (may just be EOF)");
            this.getLogger().warn(sw.toString());
        }
        finally {
            p4.close();
        }
        return lines;
    }

    protected void login() throws PerforceException {
        String sep = System.getProperty("file.separator");
        if (sep.equals("\\")) {
            Executor login = this.depot.getExecFactory().newExecutor();
            login.exec(new String[]{"p4", "login"});
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                login.getWriter().write(this.depot.getPassword() + "\n");
            }
            catch (IOException e) {
                throw new PerforceException("Failed to communicate with p4 when logging in to server.");
            }
            login.close();
        } else {
            Executor login = this.depot.getExecFactory().newExecutor();
            login.exec(new String[]{"/bin/sh", "-c", "echo \"" + this.depot.getPassword() + "\" | p4 login -p"});
            BufferedReader reader = login.getReader();
            String ticket = null;
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    ticket = line;
                }
                if (ticket != null && ticket.equals("/bin/sh: p4: command not found")) {
                    login.close();
                    login.exec(new String[]{"/bin/sh", "-c", "echo \"" + this.depot.getPassword() + "\" | /usr/bin/p4 login -p"});
                    reader = login.getReader();
                    while ((line = reader.readLine()) != null) {
                        ticket = line;
                    }
                }
            }
            catch (IOException e) {
                throw new PerforceException("Unable to login via p4 login due to IOException: " + e.getMessage());
            }
            if (ticket != null) {
                this.getLogger().warn("Using p4 issued ticket.");
                this.depot.setP4Ticket(ticket);
            }
            login.close();
        }
    }
}

