/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce.parse;

import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Workspace;
import com.tek42.perforce.parse.AbstractPerforceTemplate;
import com.tek42.perforce.parse.Builder;
import com.tek42.perforce.parse.WorkspaceBuilder;

public class Workspaces
extends AbstractPerforceTemplate {
    public Workspaces(Depot depot) {
        super(depot);
    }

    public Workspace getWorkspace(String name) throws PerforceException {
        WorkspaceBuilder builder = new WorkspaceBuilder();
        Workspace workspace = (Workspace)builder.build(this.getPerforceResponse(builder.getBuildCmd(this.getP4Exe(), name)));
        if (workspace == null) {
            throw new PerforceException("Failed to retrieve workspace: " + name);
        }
        return workspace;
    }

    public void saveWorkspace(Workspace workspace) throws PerforceException {
        WorkspaceBuilder builder = new WorkspaceBuilder();
        this.saveToPerforce((Object)workspace, (Builder)builder);
    }

    public StringBuilder syncToHead(String path) throws PerforceException {
        return this.syncToHead(path, false);
    }

    public StringBuilder syncToHead(String path, boolean forceSync) throws PerforceException {
        if (!path.endsWith("#head")) {
            path = path + "#head";
        }
        return this.syncTo(path, forceSync);
    }

    public StringBuilder syncTo(String path, boolean forceSync) throws PerforceException {
        if (forceSync) {
            return this.getPerforceResponse(new String[]{this.getP4Exe(), "sync", "-f", path});
        }
        return this.getPerforceResponse(new String[]{this.getP4Exe(), "sync", path});
    }

    public StringBuilder syncDryRun() throws PerforceException {
        StringBuilder result = this.getPerforceResponse(new String[]{this.getP4Exe(), "sync", "-n"});
        return result;
    }
}

