package hudson.plugins.perforce;

import com.tek42.perforce.PerforceException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Project;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.tasks.MailAddressResolver;
import hudson.util.StreamTaskListener;
import java.io.File;

/**
 * Implementation of {@link MailAddressResolver} for looking up the email address of a user in the Perforce repository.
 *
 * @author Mike
 *         Date: Apr 22, 2008 2:01:37 PM
 */
@Extension
public class PerforceMailResolver extends MailAddressResolver {
	
    @SuppressWarnings("unchecked")
    public String findMailAddressFor(User u) {
    	
        for (AbstractProject p : u.getProjects()) {
            if (p.isDisabled()) continue;
            if (p.getScm() instanceof PerforceSCM) {
                PerforceSCM pscm = (PerforceSCM) p.getScm();
                TaskListener listener = new StreamTaskListener(System.out);
                Node node = p.getLastBuiltOn();
                // If the node is offline, skip the project.
                // The node needs to be online for us to execute commands.
                if (node.getChannel() == null) {
                    continue;
                }
                // TODO: replace this with p.getLastBuild().getWorkspace()
                // which is the way it should be, but doesn't work with this version of hudson.
                for (int tries = 0; tries < 5; tries++) {
                    FilePath workspace = p.getLastBuiltOn().getRootPath();
                    Launcher launcher = p.getLastBuiltOn().createLauncher(listener);
                    com.tek42.perforce.model.User pu = null;
                    try {
                        listener.getLogger().println("Trying to get email address from perforce for " + u.getId());
                        pu = pscm.getDepot(launcher, workspace).getUsers().getUser(u.getId());
                    } catch (Exception e) {
                        listener.getLogger().println("Could not get email address from Perforce: " + e.getMessage());
                        e.printStackTrace(listener.getLogger());
                    }
                    if (pu != null && pu.getEmail() != null && !pu.getEmail().equals("")) {
                        listener.getLogger().println("Got email (" + pu.getEmail() + ") from perforce for " + u.getId());
                        return pu.getEmail();
                    }
                    try {
                        //gradually increase sleep time
                        Thread.sleep(tries*300);
                    } catch (InterruptedException e){
                        return null;
                    }
                }
            }
        }
        return null;
    }

}
