/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.api;

import com.perforce.api.Cacheable;
import com.perforce.api.Change;
import com.perforce.api.CommitException;
import com.perforce.api.Debug;
import com.perforce.api.Env;
import com.perforce.api.FileEntry;
import com.perforce.api.HashDecay;
import com.perforce.api.Mapping;
import com.perforce.api.P4Process;
import com.perforce.api.PerforceException;
import com.perforce.api.User;
import com.perforce.api.Utils;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

/*
 * Exception performing whole class analysis ignored.
 */
public class Branch
extends Mapping {
    private static HashDecay branches = null;

    public Branch() {
        this.getCache();
    }

    public Branch(String name) {
        this();
        this.setName(name);
    }

    private static HashDecay setCache() {
        if (null == branches) {
            branches = new HashDecay(1200000L);
            branches.start();
        }
        return branches;
    }

    public HashDecay getCache() {
        return Branch.setCache();
    }

    public static Enumeration lookupBranches(String prefix) {
        return Branch.lookupMappings((HashDecay)branches, (String)prefix);
    }

    public static void loadBranches() {
        Branch.loadBranches(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadBranches(Env env) {
        String[] cmd = new String[]{"p4", "branches"};
        Branch.setCache();
        try {
            String l;
            P4Process p = new P4Process(env);
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                Branch b;
                StringTokenizer st;
                if (!l.startsWith("Branch") || 6 > (st = new StringTokenizer(l)).countTokens()) continue;
                st.nextToken();
                String name = st.nextToken();
                HashDecay hashDecay = branches;
                synchronized (hashDecay) {
                    b = (Branch)branches.get((Object)name);
                    if (null != b) {
                        b.refreshUpdateTime();
                        continue;
                    }
                    b = new Branch(name);
                    b.setEnv(env);
                }
                st.nextToken();
                st.nextToken("'");
                b.setDescription(st.nextToken());
                branches.put((Object)b.getName(), (Cacheable)b);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Enumeration getBranchNames(Env env) {
        Branch.loadBranches((Env)env);
        return branches.keys();
    }

    public static Enumeration getBranches() {
        return Branch.getBranches(null);
    }

    public static Enumeration getBranches(Env env) {
        return Utils.getEnumeration((Iterator)Branch.getBranchIterator((Env)env));
    }

    public static Iterator getBranchIterator(Env env) {
        Branch.loadBranches((Env)env);
        Enumeration en = branches.elements();
        TreeSet ts = new TreeSet();
        while (en.hasMoreElements()) {
            ts.add(en.nextElement());
        }
        return ts.iterator();
    }

    public static synchronized Branch getBranch(String name) {
        return Branch.getBranch(null, (String)name, (boolean)true);
    }

    public static synchronized Branch getBranch(Env env, String name, boolean force) {
        if (null == name || name.trim().equals("")) {
            return null;
        }
        Branch b = (Branch)Branch.setCache().get((Object)name);
        if (null == b) {
            b = new Branch(name);
        }
        if (null != env) {
            b.setEnv(env);
        }
        b.sync();
        branches.put((Object)name, (Cacheable)b);
        return b;
    }

    public static Change integrate(Env env, Vector fents, String branch, StringBuffer sb, String description) throws CommitException, PerforceException {
        Change c = new Change();
        c.setEnv(env);
        c.setDescription(description);
        c.setUser(User.getUser((String)env.getUser()));
        c.setClientName(env.getClient());
        c.commit();
        return Branch.integrate((Env)env, (Vector)fents, (String)branch, (StringBuffer)sb, (Change)c);
    }

    public static Change integrate(Env env, Vector fents, String branch, StringBuffer sb, Change c) throws PerforceException {
        Enumeration en = fents.elements();
        while (en.hasMoreElements()) {
            FileEntry fent = (FileEntry)en.nextElement();
            Branch.integrate((Env)env, (String)(fent.getDepotPath() + "#" + fent.getHeadRev()), (String)branch, (StringBuffer)sb, (Change)c);
        }
        return c;
    }

    public Change integrate(String source, StringBuffer sb, Change c) throws PerforceException {
        if (null == c) {
            c = new Change();
            c.setDescription("Automated Integration");
            c.commit();
        }
        return Branch.integrate((Env)this.getEnv(), (String)source, (String)this.getName(), (StringBuffer)sb, (Change)c);
    }

    public static Change integrate(Env env, String source, String branch, StringBuffer sb, Change c) throws PerforceException {
        String[] intcmd = new String[]{"p4", "integrate", "-v", "-d", "-c", String.valueOf(c.getNumber()), "-b", branch, "-s", source};
        intcmd[5] = String.valueOf(c.getNumber());
        for (int i = 0; i < 8; ++i) {
            sb.append(intcmd[i]);
            sb.append(' ');
        }
        sb.append('\n');
        try {
            String l;
            P4Process p = new P4Process(env);
            p.exec(intcmd);
            while (null != (l = p.readLine())) {
                if (null == sb) continue;
                sb.append(l);
                sb.append('\n');
            }
            p.close();
        }
        catch (Exception ex) {
            throw new PerforceException(ex.getMessage());
        }
        return c;
    }

    public void store() throws CommitException {
        this.commit();
    }

    public void commit() throws CommitException {
        String[] cmd = new String[]{"p4", "branch", "-i"};
        try {
            String l;
            P4Process p = new P4Process(this.getEnv());
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                p.println("Branch: " + this.getName());
                p.println("Owner: " + this.getOwner());
                p.println("View:");
                p.println(this.getView());
                p.flush();
                p.outClose();
                while (null != (l = p.readLine())) {
                }
                p.close();
            }
        }
        catch (Exception ex) {
            throw new CommitException(ex.getMessage());
        }
    }

    public void sync() {
        this.sync(this.getName());
    }

    public void sync(String name) {
        if (!this.outOfSync(300000L)) {
            return;
        }
        this.setName(name);
        String description = "";
        String[] cmd = new String[]{"p4", "branch", "-o", "name"};
        cmd[3] = name;
        try {
            String l;
            P4Process p = new P4Process(this.getEnv());
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                if (l.startsWith("#")) continue;
                if (l.startsWith("Branch:")) {
                    this.setName(l.substring(8).trim());
                    continue;
                }
                if (l.startsWith("Owner:")) {
                    this.setOwner(l.substring(7).trim());
                    continue;
                }
                if (l.startsWith("Description:")) {
                    while (null != (l = p.readLine()) && l.startsWith("\t")) {
                        description = description + l + "\n";
                    }
                    this.setDescription(description);
                    continue;
                }
                if (!l.startsWith("View:")) continue;
                while (null != (l = p.readLine()) && (l.startsWith("\t") || l.startsWith(" ") || l.startsWith("//"))) {
                    this.addView(l);
                }
            }
            p.close();
            this.inSync();
        }
        catch (IOException ex) {
            Debug.out((int)1, (Throwable)ex);
        }
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer("<branch name=\"");
        sb.append(this.getName());
        sb.append("\" owner=\"");
        sb.append(this.getOwner());
        sb.append("\">");
        sb.append(super.toXML());
        sb.append("</branch>");
        return sb.toString();
    }
}

