/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce.parse;

import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Workspace;
import com.tek42.perforce.parse.AbstractFormBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceBuilder
extends AbstractFormBuilder<Workspace> {
    @Override
    public Workspace buildForm(Map<String, String> fields) throws PerforceException {
        Workspace workspace = new Workspace();
        workspace.setName(this.getField("Client", fields));
        workspace.setOwner(this.getField("Owner", fields));
        workspace.setHost(this.getField("Host", fields));
        workspace.setRoot(this.getField("Root", fields));
        workspace.setOptions(this.getField("Options", fields));
        workspace.setSubmitOptions(this.getField("SubmitOptions", fields));
        workspace.setLineEnd(this.getField("LineEnd", fields));
        workspace.setAltRoots(this.getField("AltRoots", fields));
        workspace.setDescription(this.getField("Description", fields));
        workspace.setUpdate(this.getField("Update", fields));
        workspace.setAccess(this.getField("Access", fields));
        for (String line : this.getField("View", fields).split("\\n")) {
            workspace.addView(line);
        }
        workspace.clearDirty();
        return workspace;
    }

    @Override
    public String[] getBuildCmd(String p4exe, String id) {
        return new String[]{p4exe, "workspace", "-o", id};
    }

    @Override
    public String[] getSaveCmd(String p4exe, Workspace obj) {
        return new String[]{p4exe, "-s", "client", "-i"};
    }

    @Override
    public void save(Workspace workspace, Writer out) throws PerforceException {
        try {
            out.write("Client: " + workspace.getName() + "\n");
            if (!workspace.getOwner().equals("")) {
                out.write("Owner: " + workspace.getOwner() + "\n");
            }
            if (!workspace.getHost().equals("")) {
                out.write("Host: " + workspace.getHost() + "\n");
            }
            out.write("Description: " + workspace.getDescription() + "\n");
            out.write("Root: " + workspace.getRoot() + "\n");
            if (!workspace.getAltRoots().equals("")) {
                out.write("AltRoots: " + workspace.getAltRoots() + "\n");
            }
            out.write("Options: " + workspace.getOptions() + "\n");
            if (!workspace.getSubmitOptions().equals("")) {
                out.write("SubmitOptions: " + workspace.getSubmitOptions() + "\n");
            }
            out.write("LineEnd: " + workspace.getLineEnd() + "\n");
            out.write("View:\n");
            out.write(" " + workspace.getViewsAsString() + "\n");
        }
        catch (IOException e) {
            throw new PerforceException("Failed to save workspace", e);
        }
    }
}

