/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.api;

import com.perforce.api.Utils;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

/*
 * Exception performing whole class analysis ignored.
 */
public class EventLog {
    private static EventLog primary = null;
    private String title = "EventLog";
    private String filename = "log.txt";
    private PrintWriter fout = null;
    private Vector events;
    private int max_events = 100;
    private DateFormat fmt;

    public EventLog() {
        this(null, null);
    }

    public EventLog(String title) {
        this(title, null);
    }

    public EventLog(String title, String filename) {
        this.title = null == title ? "EventLog" : title;
        this.filename = null == filename ? "log.txt" : filename;
        this.events = new Vector();
        this.fmt = DateFormat.getDateTimeInstance(3, 2);
        if (null == primary) {
            primary = this;
        }
        try {
            this.fout = new PrintWriter(new FileOutputStream(filename, true));
        }
        catch (Exception ex) {
            this.fout = null;
        }
    }

    public String getFileName() {
        return this.filename;
    }

    public int getSize() {
        return this.max_events;
    }

    public synchronized void setSize(int size) {
        this.max_events = size;
    }

    public static void commonLog(String event, String level, boolean encode) {
        if (null != primary) {
            primary.log(event, level, encode);
        } else {
            System.out.println(event);
        }
    }

    public static void commonLog(String event, String level) {
        if (null != primary) {
            primary.log(event, level);
        } else {
            System.out.println(event);
        }
    }

    public static void commonLog(String event) {
        if (null != primary) {
            primary.log(event);
        } else {
            System.out.println(event);
        }
    }

    public synchronized void log(String event) {
        this.log(event, null, true);
    }

    public synchronized void log(String event, String level) {
        this.log(event, level, true);
    }

    public synchronized void log(String event, String level, boolean encode) {
        StringBuffer sb = new StringBuffer("<log level=\"");
        if (null == level) {
            if (-1 == event.indexOf("ERROR")) {
                sb.append("NOMINAL");
            } else {
                sb.append("ERROR");
            }
        } else {
            sb.append(level);
        }
        sb.append("\" date=\"");
        sb.append(this.fmt.format(new Date()));
        sb.append("\">");
        if (encode) {
            sb.append(Utils.HTMLEncode((String)event));
        } else {
            sb.append(event);
        }
        sb.append("</log>");
        String msg = sb.toString();
        this.events.insertElementAt(msg, 0);
        if (null != this.fout) {
            this.fout.println(msg);
            this.fout.flush();
        }
        if (this.max_events < this.events.size()) {
            this.events.removeElementAt(this.max_events);
        }
    }

    public synchronized Enumeration getLog() {
        return this.events.elements();
    }

    public static void printLog(PrintWriter out, String format) {
        EventLog.printLog((EventLog)primary, (PrintWriter)out, (String)format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printLog(EventLog elog, PrintWriter out, String format) {
        Object[] args = new Object[]{"foo"};
        EventLog eventLog = elog;
        synchronized (eventLog) {
            Enumeration en = elog.events.elements();
            while (en.hasMoreElements()) {
                args[0] = (String)en.nextElement();
                out.println(MessageFormat.format(format, args));
            }
        }
    }

    public synchronized void setTitle(String title) {
        this.title = title;
    }

    public synchronized String getTitle() {
        return this.title;
    }
}

