/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce.parse;

import com.tek42.perforce.PerforceException;
import com.tek42.perforce.parse.Builder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFormBuilder<T>
implements Builder<T> {
    private final Logger logger = LoggerFactory.getLogger((String)"perforce");

    public T build(StringBuilder sb) throws PerforceException {
        sb.append("Endp:\n");
        this.logger.debug("Parsing: \n" + sb);
        Pattern p = Pattern.compile("^(\\w+):(.*?)(?=\\n\\w{4,}?:)", 40);
        Matcher m = p.matcher(sb.toString());
        HashMap<String, String> fields = new HashMap<String, String>();
        this.logger.debug("Parsing response...");
        while (m.find()) {
            String key = m.group(1);
            String value = m.group(2).trim();
            fields.put(key, value);
            this.logger.debug("Have key: " + key + " = " + value);
        }
        return (T)this.buildForm(fields);
    }

    protected String getField(String key, Map<String, String> fields) {
        String value = fields.get(key);
        if (value == null) {
            return "";
        }
        return value;
    }

    protected List<String> getFieldAsList(String key, Map<String, String> fields) {
        String value = fields.get(key);
        if (value == null || value.equals("") || value.equals("\n")) {
            return new ArrayList<String>();
        }
        String[] values = value.split("\\n");
        ArrayList<String> list = new ArrayList<String>(values.length);
        list.addAll(Arrays.asList(values));
        return list;
    }

    public boolean requiresStandardInput() {
        return true;
    }

    public abstract T buildForm(Map<String, String> var1) throws PerforceException;
}

