/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce.parse;

import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Group;
import com.tek42.perforce.parse.AbstractPerforceTemplate;
import com.tek42.perforce.parse.Builder;
import com.tek42.perforce.parse.GroupBuilder;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Groups
extends AbstractPerforceTemplate {
    public Groups(Depot depot) {
        super(depot);
    }

    public Group getGroup(String name) throws PerforceException {
        GroupBuilder builder = new GroupBuilder();
        Group group = (Group)builder.build(this.getPerforceResponse(builder.getBuildCmd(this.getP4Exe(), name)));
        if (group == null) {
            throw new PerforceException("Failed to retrieve group: " + name);
        }
        return group;
    }

    public void saveGroup(Group group) throws PerforceException {
        GroupBuilder builder = new GroupBuilder();
        this.saveToPerforce((Object)group, (Builder)builder);
    }

    public List<Group> getGroups() throws PerforceException {
        String[] cmd = new String[]{this.getP4Exe(), "groups"};
        StringBuilder response = this.getPerforceResponse(cmd);
        List names = this.parseList(response, 0);
        ArrayList<Group> groups = new ArrayList<Group>();
        for (String name : names) {
            groups.add(this.getGroup(name));
        }
        return groups;
    }
}

