/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce.process;

import com.tek42.perforce.PerforceException;
import com.tek42.perforce.process.Executor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdLineExecutor
implements Executor {
    ProcessBuilder builder;
    Process currentProcess;
    List<String> args;
    BufferedWriter writer;
    BufferedReader reader;
    private final Logger logger = LoggerFactory.getLogger((String)"perforce");

    public CmdLineExecutor(Map<String, String> environment) {
        this.args = new ArrayList();
        this.builder = new ProcessBuilder(this.args);
        Map<String, String> env = this.builder.environment();
        for (Map.Entry<String, String> entry : environment.entrySet()) {
            env.put(entry.getKey(), entry.getValue());
        }
    }

    public void exec(String[] args) throws PerforceException {
        this.args.clear();
        StringBuilder debug = new StringBuilder();
        for (String arg : args) {
            debug.append(arg + " ");
            this.args.add(arg);
        }
        this.logger.info("Executing: " + debug);
        this.builder.redirectErrorStream(true);
        try {
            this.currentProcess = this.builder.start();
            this.reader = new BufferedReader(new InputStreamReader(this.currentProcess.getInputStream()));
            this.writer = new BufferedWriter(new OutputStreamWriter(this.currentProcess.getOutputStream()));
        }
        catch (IOException e) {
            throw new PerforceException("Failed to open connection to: " + args[0], (Throwable)e);
        }
    }

    public BufferedReader getReader() {
        return this.reader;
    }

    public BufferedWriter getWriter() {
        return this.writer;
    }

    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            this.reader = null;
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            this.writer = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Process getProcess() {
        return this.currentProcess;
    }
}

