/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Changelist;
import com.tek42.perforce.model.Workspace;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.perforce.PerforceChangeLogParser;
import hudson.plugins.perforce.PerforceChangeLogSet;
import hudson.plugins.perforce.PerforceRepositoryBrowser;
import hudson.plugins.perforce.PerforceSCM;
import hudson.plugins.perforce.PerforceSCMHelper;
import hudson.plugins.perforce.PerforceTagAction;
import hudson.scm.ChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerforceSCM
extends SCM {
    public static final PerforceSCMDescriptor DESCRIPTOR = new PerforceSCMDescriptor(null);
    String p4User;
    String p4Passwd;
    String p4Port;
    String p4Client;
    String projectPath;
    String p4Exe = "C:\\Program Files\\Perforce\\p4.exe";
    String p4SysDrive = "C:";
    String p4SysRoot = "C:\\WINDOWS";
    Depot depot;
    PerforceRepositoryBrowser browser;
    transient int lastChange;
    boolean forceSync = false;
    boolean updateView = true;
    int firstChange = -1;

    public PerforceSCM(String p4User, String p4Pass, String p4Client, String p4Port, String projectPath, String p4Exe, String p4SysRoot, String p4SysDrive, boolean forceSync, boolean updateView, int firstChange, PerforceRepositoryBrowser browser) {
        this.p4User = p4User;
        this.p4Passwd = p4Pass;
        this.p4Client = p4Client;
        this.p4Port = p4Port;
        this.projectPath = projectPath;
        if (p4Exe != null) {
            this.p4Exe = p4Exe;
        }
        if (p4SysRoot != null) {
            this.p4SysRoot = p4SysRoot;
        }
        if (p4SysDrive != null) {
            this.p4SysDrive = p4SysDrive;
        }
        this.forceSync = forceSync;
        this.browser = browser;
        this.updateView = updateView;
        this.firstChange = firstChange;
    }

    private Depot getDepot() {
        if (this.depot == null) {
            this.depot = new Depot();
            this.depot.setUser(this.p4User);
            this.depot.setPassword(this.p4Passwd);
            this.depot.setPort(this.p4Port);
            this.depot.setClient(this.p4Client);
            this.depot.setExecutable(this.p4Exe);
            this.depot.setSystemDrive(this.p4SysDrive);
            this.depot.setSystemRoot(this.p4SysRoot);
        }
        return this.depot;
    }

    private String getLocalPathName(FilePath path) throws IOException, InterruptedException {
        String uriString = path.toURI().toString();
        uriString = uriString.replaceAll("file:/", "");
        uriString = uriString.replaceAll("/./", "/");
        uriString = URLDecoder.decode(uriString, "UTF-8");
        String sep = System.getProperty("file.separator");
        uriString = sep.equals("\\") ? uriString.replaceAll("/", "\\\\") : "/" + uriString;
        return uriString;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        int lastChange;
        block10: {
            listener.getLogger().println("Performing sync with Perforce for: " + this.projectPath);
            Workspace p4workspace = this.getDepot().getWorkspaces().getWorkspace(this.p4Client);
            assert (p4workspace != null);
            boolean creatingNewWorkspace = p4workspace.getAccess() == null || p4workspace.getAccess().length() == 0;
            String localPath = this.getLocalPathName(workspace);
            listener.getLogger().println("Changing P4 Client Root to: " + localPath);
            p4workspace.setRoot(localPath);
            if (this.updateView || creatingNewWorkspace) {
                String view = this.projectPath + " //" + p4workspace.getName() + "/...";
                listener.getLogger().println("Changing P4 Client View to: " + view);
                p4workspace.clearViews();
                p4workspace.addView(view);
            }
            p4workspace.setHost("");
            if (!this.updateView && p4workspace.getViews().size() > 1 && !this.projectPath.equals("//...")) {
                throw new PerforceException("the only project path currently supported when you have multiple workspace views is '//...'. Please revise your project path or P4 workspace accordingly.");
            }
            this.depot.getWorkspaces().saveWorkspace(p4workspace);
            lastChange = this.getLastChange(build.getPreviousBuild());
            listener.getLogger().println("Last sync'd change: " + lastChange);
            List changes = this.depot.getChanges().getChangelistsFromNumbers(this.depot.getChanges().getChangeNumbersTo(this.getChangesPaths(p4workspace), lastChange + 1));
            if (changes.size() > 0) {
                lastChange = ((Changelist)changes.get(0)).getChangeNumber();
                PerforceChangeLogSet.saveToChangeLog((OutputStream)new FileOutputStream(changelogFile), (List)changes);
                break block10;
            }
            if (this.forceSync) break block10;
            listener.getLogger().println("No changes since last build.");
            boolean bl = this.createEmptyChangeLog(changelogFile, listener, "changelog");
            return bl;
        }
        try {
            long startTime = System.currentTimeMillis();
            listener.getLogger().println("Sync'ing workspace to depot.");
            if (this.forceSync) {
                listener.getLogger().println("ForceSync flag is set, forcing: p4 sync " + this.projectPath);
            }
            this.depot.getWorkspaces().syncToHead(this.projectPath, this.forceSync);
            this.forceSync = false;
            this.firstChange = -1;
            listener.getLogger().println("Sync complete, took " + (System.currentTimeMillis() - startTime) + " MS");
            build.addAction((Action)new PerforceTagAction(build, this.depot, lastChange, this.projectPath));
            build.getParent().save();
            boolean bl = true;
            return bl;
        }
        catch (PerforceException e) {
            listener.getLogger().print("Caught Exception communicating with perforce. " + e.getMessage());
            e.printStackTrace();
            throw new IOException("Unable to communicate with perforce. " + e.getMessage());
        }
    }

    private String getChangesPaths(Workspace p4workspace) {
        String changesPath = p4workspace.getViews().size() > 1 ? PerforceSCMHelper.computePathFromViews((List)p4workspace.getViews()) : this.projectPath;
        return changesPath;
    }

    public PerforceRepositoryBrowser getBrowser() {
        return this.browser;
    }

    public ChangeLogParser createChangeLogParser() {
        return new PerforceChangeLogParser();
    }

    public SCMDescriptor<?> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        try {
            int lastChange = this.getLastChange(project.getLastBuild());
            listener.getLogger().println("Looking for changes...");
            Workspace p4workspace = this.getDepot().getWorkspaces().getWorkspace(this.p4Client);
            List changes = this.depot.getChanges().getChangeNumbersTo(this.getChangesPaths(p4workspace), lastChange + 1);
            listener.getLogger().println("Last sync'd change is : " + lastChange);
            if (changes.size() > 0) {
                listener.getLogger().println("New changes detected, triggering a build.");
                return true;
            }
            listener.getLogger().println("We have nothing to do.");
            return false;
        }
        catch (PerforceException e) {
            System.out.println("Problem: " + e.getMessage());
            listener.getLogger().println("Caught Exception communicating with perforce." + e.getMessage());
            e.printStackTrace();
            throw new IOException("Unable to communicate with perforce.  Check log file for: " + e.getMessage());
        }
    }

    public int getLastChange(Run build) {
        if (this.firstChange > 0) {
            return this.firstChange;
        }
        if (build == null) {
            return 0;
        }
        PerforceTagAction action = (PerforceTagAction)build.getAction(PerforceTagAction.class);
        if (action == null) {
            return this.getLastChange(build.getPreviousBuild());
        }
        return action.getChangeNumber();
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    public String getP4User() {
        return this.p4User;
    }

    public void setP4User(String user) {
        this.p4User = user;
    }

    public String getP4Passwd() {
        return this.p4Passwd;
    }

    public void setP4Passwd(String passwd) {
        this.p4Passwd = passwd;
    }

    public String getP4Port() {
        return this.p4Port;
    }

    public void setP4Port(String port) {
        this.p4Port = port;
    }

    public String getP4Client() {
        return this.p4Client;
    }

    public void setP4Client(String client) {
        this.p4Client = client;
    }

    public String getP4SysDrive() {
        return this.p4SysDrive;
    }

    public void setP4SysDrive(String sysDrive) {
        this.p4SysDrive = sysDrive;
    }

    public String getP4SysRoot() {
        return this.p4SysRoot;
    }

    public void setP4SysRoot(String sysRoot) {
        this.p4SysRoot = sysRoot;
    }

    public String getP4Exe() {
        return this.p4Exe;
    }

    public void setP4Exe(String exe) {
        this.p4Exe = exe;
    }

    public void setUpdateView(boolean update) {
        this.updateView = update;
    }

    public boolean isUpdateView() {
        return this.updateView;
    }

    public boolean isForceSync() {
        return this.forceSync;
    }

    public void setForceSync(boolean force) {
        this.forceSync = force;
    }

    public String getFirstChange() {
        if (this.firstChange < 0) {
            return "";
        }
        return new Integer(this.firstChange).toString();
    }
}

