/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Label;
import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import hudson.scm.AbstractScmTagAction;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class PerforceTagAction
extends AbstractScmTagAction {
    private int changeNumber;
    private Depot depot;
    private String tag;
    private String desc;
    private String view;

    public PerforceTagAction(AbstractBuild build, Depot depot, int changeNumber, String view) {
        super(build);
        this.depot = depot;
        this.changeNumber = changeNumber;
        this.view = view;
    }

    public int getChangeNumber() {
        return this.changeNumber;
    }

    public String getIconFileName() {
        if (this.tag == null && !Hudson.isAdmin()) {
            return null;
        }
        return "save.gif";
    }

    public String getDisplayName() {
        if (this.isTagged()) {
            return "Perforce Label";
        }
        return "Label This Build";
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getDescription() {
        return this.desc;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public boolean isTagged() {
        return this.tag != null;
    }

    public String isInvalidTag(String tag) {
        Pattern spaces = Pattern.compile("\\s{1,}");
        Matcher m = spaces.matcher(tag);
        if (m.find()) {
            return "Spaces are not allowed.";
        }
        return null;
    }

    public synchronized void doCheckTag(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        new /* Unavailable Anonymous Inner Class!! */.check();
    }

    public synchronized void doSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        if (!Hudson.adminCheck((StaplerRequest)req, (StaplerResponse)rsp)) {
            return;
        }
        this.tag = req.getParameter("name");
        this.desc = req.getParameter("desc");
        Label label = new Label();
        label.setName(this.tag);
        label.setDescription(this.desc);
        label.setRevision(new Integer(this.changeNumber).toString());
        label.addView(this.view);
        try {
            this.depot.getLabels().saveLabel(label);
        }
        catch (PerforceException e) {
            this.tag = null;
            this.desc = null;
            e.printStackTrace();
            throw new IOException("Failed to issue perforce label.", e);
        }
        this.build.save();
        rsp.sendRedirect(".");
    }
}

