/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce.browsers;

import com.tek42.perforce.model.Changelist;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.plugins.perforce.PerforceChangeLogEntry;
import hudson.plugins.perforce.PerforceRepositoryBrowser;
import hudson.plugins.perforce.browsers.QueryBuilder;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormFieldValidator;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public final class FishEyePerforce
extends PerforceRepositoryBrowser {
    public final URL url;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public FishEyePerforce(URL url) {
        this.url = FishEyePerforce.normalizeToEndWithSlash((URL)url);
    }

    public URL getDiffLink(Changelist.FileEntry file) throws IOException {
        if (file.getAction() != Changelist.FileEntry.Action.EDIT && file.getAction() != Changelist.FileEntry.Action.INTEGRATE) {
            return null;
        }
        int r = new Integer(file.getRevision());
        if (r <= 1) {
            return null;
        }
        return new URL(this.url, FishEyePerforce.trimHeadSlash((String)file.getFilename()) + new QueryBuilder(this.url.getQuery()).add("r1=" + (r - 1)).add("r2=" + r));
    }

    public URL getFileLink(Changelist.FileEntry file) throws IOException {
        return new URL(this.url, FishEyePerforce.trimHeadSlash((String)file.getFilename()) + new QueryBuilder(this.url.getQuery()));
    }

    public URL getChangeSetLink(PerforceChangeLogEntry change) throws IOException {
        return new URL(this.url, "../../changelog/" + this.getProjectName() + "/?cs=" + change.getChange().getChangeNumber());
    }

    private String getProjectName() {
        String p = this.url.getPath();
        if (p.endsWith("/")) {
            p = p.substring(0, p.length() - 1);
        }
        int idx = p.lastIndexOf(47);
        return p.substring(idx + 1);
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        private static final Pattern URL_PATTERN = Pattern.compile(".+/browse/[^/]+/");

        public DescriptorImpl() {
            super(FishEyePerforce.class);
        }

        public String getDisplayName() {
            return "FishEye";
        }

        public void doCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator.URLCheck(req, rsp){

                protected void check() throws IOException, ServletException {
                    String value = Util.fixEmpty((String)this.request.getParameter("value"));
                    if (value == null) {
                        this.ok();
                        return;
                    }
                    if (!value.endsWith("/")) {
                        value = value + '/';
                    }
                    if (!URL_PATTERN.matcher(value).matches()) {
                        this.errorWithMarkup("The URL should end like <tt>.../browse/foobar/</tt>");
                        return;
                    }
                    try {
                        if (this.findText(this.open(new URL(value)), "FishEye")) {
                            this.ok();
                        } else {
                            this.error("This is a valid URL but it doesn't look like FishEye");
                        }
                    }
                    catch (IOException e) {
                        this.handleIOException(value, e);
                    }
                }
            }.process();
        }

        public FishEyePerforce newInstance(StaplerRequest req) throws Descriptor.FormException {
            return (FishEyePerforce)((Object)req.bindParameters(FishEyePerforce.class, "fisheye.perforce."));
        }
    }
}

