/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import com.tek42.perforce.model.Changelist;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.plugins.perforce.PerforceChangeLogEntry;
import hudson.scm.ChangeLogSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class PerforceChangeLogSet
extends ChangeLogSet<PerforceChangeLogEntry> {
    private List<PerforceChangeLogEntry> history = null;

    public PerforceChangeLogSet(AbstractBuild<?, ?> build, List<PerforceChangeLogEntry> logs) {
        super(build);
        this.history = Collections.unmodifiableList(logs);
    }

    public List<PerforceChangeLogEntry> getHistory() {
        return this.history;
    }

    public boolean isEmptySet() {
        return this.history.size() == 0;
    }

    public Iterator<PerforceChangeLogEntry> iterator() {
        return this.history.iterator();
    }

    public static PerforceChangeLogSet parse(AbstractBuild build, InputStream changeLogStream) throws IOException, SAXException {
        ArrayList<PerforceChangeLogEntry> history = new ArrayList<PerforceChangeLogEntry>();
        SAXReader reader = new SAXReader();
        Document changeDoc = null;
        try {
            changeDoc = reader.read(changeLogStream);
            Node historyNode = changeDoc.selectSingleNode("/changelog");
            if (historyNode == null) {
                return new PerforceChangeLogSet(build, history);
            }
            List entries = historyNode.selectNodes("entry");
            if (entries == null) {
                return new PerforceChangeLogSet(build, history);
            }
            for (Node node : entries) {
                Changelist change = new Changelist();
                if (node.selectSingleNode("changenumber") != null) {
                    change.setChangeNumber(new Integer(node.selectSingleNode("changenumber").getStringValue()).intValue());
                }
                if (node.selectSingleNode("date") != null) {
                    change.setDate(PerforceChangeLogSet.stringDateToJavaDate((String)node.selectSingleNode("date").getStringValue()));
                }
                if (node.selectSingleNode("description") != null) {
                    change.setDescription(node.selectSingleNode("description").getStringValue());
                }
                if (node.selectSingleNode("user") != null) {
                    change.setUser(node.selectSingleNode("user").getStringValue());
                }
                if (node.selectSingleNode("workspace") != null) {
                    change.setWorkspace(node.selectSingleNode("workspace").getStringValue());
                }
                List fileNodes = node.selectSingleNode("files").selectNodes("file");
                ArrayList<Changelist.FileEntry> files = new ArrayList<Changelist.FileEntry>();
                for (Node fnode : fileNodes) {
                    Changelist.FileEntry file = new Changelist.FileEntry();
                    file.setFilename(fnode.selectSingleNode("name").getStringValue());
                    file.setRevision(fnode.selectSingleNode("rev").getStringValue());
                    file.setAction(Changelist.FileEntry.Action.valueOf((String)fnode.selectSingleNode("action").getStringValue()));
                    files.add(file);
                }
                change.setFiles(files);
                List jobNodes = node.selectSingleNode("jobs").selectNodes("job");
                ArrayList<Changelist.JobEntry> jobs = new ArrayList<Changelist.JobEntry>();
                for (Node jnode : jobNodes) {
                    Changelist.JobEntry job = new Changelist.JobEntry();
                    job.setJob(jnode.selectSingleNode("name").getStringValue());
                    job.setDescription(jnode.selectSingleNode("description").getStringValue());
                    job.setStatus(jnode.selectSingleNode("status").getStringValue());
                    jobs.add(job);
                }
                change.setJobs(jobs);
                PerforceChangeLogEntry entry = new PerforceChangeLogEntry();
                entry.setChange(change);
                history.add(entry);
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to parse changelog file.", e);
        }
        return new PerforceChangeLogSet(build, history);
    }

    public static void saveToChangeLog(OutputStream outputStream, List<Changelist> changes) throws IOException {
        PrintStream stream = new PrintStream(outputStream);
        stream.println("<?xml version='1.0' encoding='UTF-8'?>");
        stream.println("<changelog>");
        for (Changelist change : changes) {
            stream.println("\t<entry>");
            stream.println("\t\t<changenumber>" + change.getChangeNumber() + "</changenumber>");
            stream.println("\t\t<date>" + Util.xmlEscape((String)PerforceChangeLogSet.javaDateToStringDate((Date)change.getDate())) + "</date>");
            stream.println("\t\t<description>" + Util.xmlEscape((String)change.getDescription()) + "</description>");
            stream.println("\t\t<user>" + Util.xmlEscape((String)change.getUser()) + "</user>");
            stream.println("\t\t<workspace>" + Util.xmlEscape((String)change.getWorkspace()) + "</workspace>");
            stream.println("\t\t<files>");
            for (Changelist.FileEntry entry : change.getFiles()) {
                stream.println("\t\t\t<file>");
                stream.println("\t\t\t\t<name>" + Util.xmlEscape((String)entry.getFilename()) + "</name>");
                stream.println("\t\t\t\t<rev>" + Util.xmlEscape((String)entry.getRevision()) + "</rev>");
                stream.println("\t\t\t\t<action>" + entry.getAction() + "</action>");
                stream.println("\t\t\t</file>");
            }
            stream.println("\t\t</files>");
            stream.println("\t\t<jobs>");
            for (Changelist.FileEntry entry : change.getJobs()) {
                stream.println("\t\t\t<job>");
                stream.println("\t\t\t\t<name>" + Util.xmlEscape((String)entry.getJob()) + "</name>");
                stream.println("\t\t\t\t<description>" + Util.xmlEscape((String)entry.getDescription()) + "</description>");
                stream.println("\t\t\t\t<status>" + Util.xmlEscape((String)entry.getStatus()) + "</status>");
                stream.println("\t\t\t</job>");
            }
            stream.println("\t\t</jobs>");
            stream.println("\t</entry>");
        }
        stream.println("</changelog>");
        stream.close();
    }

    public static String javaDateToStringDate(Date newDate) {
        if (newDate == null) {
            return "";
        }
        GregorianCalendar cal = (GregorianCalendar)Calendar.getInstance();
        cal.clear();
        cal.setTime(newDate);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        String date = year + "-" + PerforceChangeLogSet.putZero((int)month) + "-" + PerforceChangeLogSet.putZero((int)day);
        if (hour + min + sec > 0) {
            date = date + " " + PerforceChangeLogSet.putZero((int)hour) + ":" + PerforceChangeLogSet.putZero((int)min) + ":" + PerforceChangeLogSet.putZero((int)sec);
        }
        return date;
    }

    protected static Date stringDateToJavaDate(String newDate) {
        if (newDate == null || newDate.equals("")) {
            return null;
        }
        String[] parts = newDate.split(" ");
        String[] date = parts[0].split("-");
        String[] time = null;
        if (parts.length > 1) {
            time = parts[1].split(":");
            time[2] = time[2].replaceAll("\\.0", "");
        } else {
            time = "00:00:00".split(":");
        }
        GregorianCalendar cal = (GregorianCalendar)Calendar.getInstance();
        cal.clear();
        cal.set(new Integer(date[0]), new Integer(date[1]) - 1, new Integer(date[2]), new Integer(time[0]), new Integer(time[1]), new Integer(time[2]));
        return cal.getTime();
    }

    private static String putZero(int i) {
        if (i < 10) {
            return "0" + i;
        }
        return i + "";
    }
}

