/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce.parse;

import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Counter;
import com.tek42.perforce.parse.AbstractPerforceTemplate;
import com.tek42.perforce.parse.CounterBuilder;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Counters
extends AbstractPerforceTemplate {
    public Counters(Depot depot) {
        super(depot);
    }

    public void saveCounter(Counter counter) throws PerforceException {
        this.saveToPerforce(counter, new CounterBuilder());
    }

    public List<Counter> getCounters() throws PerforceException {
        String[] cmd = new String[]{this.getP4Exe(), "counters"};
        ArrayList<Counter> counters = new ArrayList<Counter>();
        StringBuilder response = this.getPerforceResponse(cmd);
        List<String> names = this.parseList(response, 0);
        for (String name : names) {
            counters.add(this.getCounter(name));
        }
        return counters;
    }

    public Counter getCounter(String name) throws PerforceException {
        CounterBuilder builder = new CounterBuilder();
        Counter counter = builder.build(this.getPerforceResponse(builder.getBuildCmd(this.getP4Exe(), name)));
        counter.setName(name);
        return counter;
    }
}

