/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce.parse;

import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Changelist;
import com.tek42.perforce.parse.Builder;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ChangelistBuilder
implements Builder<Changelist> {
    private final Logger logger = LoggerFactory.getLogger((String)"perforce");

    public String[] getBuildCmd(String p4exe, String id) {
        return new String[]{p4exe, "describe", "-s", id};
    }

    public Changelist build(StringBuilder sb) throws PerforceException {
        Changelist change = null;
        StringTokenizer lines = new StringTokenizer(sb.toString(), "\n\r");
        try {
            while (lines.hasMoreElements()) {
                String line = lines.nextToken();
                this.logger.debug("Line: " + line);
                if (line.startsWith("Change")) {
                    this.logger.debug("New changelist.");
                    change = new Changelist();
                    StringTokenizer details = new StringTokenizer(line);
                    details.nextToken();
                    change.setChangeNumber(new Integer(details.nextToken()).intValue());
                    details.nextToken();
                    String user = details.nextToken();
                    change.setUser(user.substring(0, user.indexOf("@")));
                    change.setWorkspace(user.substring(user.indexOf("@") + 1));
                    details.nextToken();
                    String date = details.nextToken();
                    String time = details.nextToken();
                    change.setDate(ChangelistBuilder.parseDate((String)(date + " " + time)));
                    StringBuilder desc = new StringBuilder();
                    line = lines.nextToken();
                    while (line != null && !line.startsWith("Affected files") && !line.startsWith("Jobs fixed")) {
                        this.logger.debug("Description Line: " + line.trim());
                        desc.append(line + "\n");
                        line = lines.nextToken();
                    }
                    change.setDescription(desc.toString().trim());
                }
                if (line.startsWith("Jobs fixed")) {
                    this.logger.debug("Has jobs.");
                    ArrayList<Changelist.JobEntry> jobs = new ArrayList<Changelist.JobEntry>();
                    boolean getDesc = false;
                    Changelist.JobEntry job = new Changelist.JobEntry();
                    String description = null;
                    do {
                        line = lines.nextToken();
                        this.logger.debug("Job Line: " + line);
                        if (!getDesc) {
                            StringTokenizer details = new StringTokenizer(line);
                            job = new Changelist.JobEntry();
                            job.setJob(details.nextToken());
                            details.nextToken();
                            details.nextToken();
                            String possibleUser = details.nextToken();
                            String status = "";
                            if ("by".equals(possibleUser)) {
                                details.nextToken();
                                status = details.nextToken();
                            } else {
                                status = possibleUser;
                            }
                            job.setStatus(status);
                            description = "";
                            getDesc = true;
                            continue;
                        }
                        while (!line.startsWith("Affected files")) {
                            description = description + line;
                            if (!lines.hasMoreElements()) break;
                            description = description + "\n";
                            line = lines.nextToken();
                        }
                        job.setDescription(description.trim());
                        jobs.add(job);
                        getDesc = false;
                    } while (!line.startsWith("Affected files"));
                    change.setJobs(jobs);
                }
                if (!line.startsWith("Affected files")) continue;
                this.logger.debug("reading files...");
                ArrayList<Changelist.FileEntry> files = new ArrayList<Changelist.FileEntry>();
                while (lines.hasMoreElements()) {
                    String entry = lines.nextToken();
                    this.logger.debug("File Line: " + entry);
                    int revStart = entry.indexOf("#");
                    if (revStart < 0) continue;
                    String filename = entry.substring(4, revStart);
                    String rev = entry.substring(revStart + 1, entry.indexOf(" ", revStart));
                    String action = entry.substring(entry.indexOf(" ", revStart) + 1);
                    action = action.replace('/', '_');
                    Changelist.FileEntry file = new Changelist.FileEntry();
                    file.setFilename(filename);
                    file.setRevision(rev);
                    file.setChangelist(change);
                    file.setAction(Changelist.FileEntry.Action.valueOf((String)action.toUpperCase(Locale.US)));
                    files.add(file);
                }
                change.setFiles(files);
            }
        }
        catch (Exception e) {
            this.logger.error("Exception: " + e.getMessage());
            throw new PerforceException("Failed to retrieve changelist.\nResponse from perforce was:\n" + sb, (Throwable)e);
        }
        return change;
    }

    public String[] getSaveCmd(String p4exe, Changelist obj) {
        return new String[]{p4exe, "change", "-i"};
    }

    public boolean requiresStandardInput() {
        return true;
    }

    public void save(Changelist obj, Writer out) throws PerforceException {
        throw new UnsupportedOperationException("This is not implemented.");
    }

    public static Date parseDate(String newDate) {
        if (newDate == null || newDate.equals("")) {
            return null;
        }
        String[] parts = newDate.split(" ");
        String[] date = parts[0].split("/");
        String[] time = null;
        if (parts.length > 1) {
            time = parts[1].split(":");
            time[2] = time[2].replaceAll("\\.0", "");
        } else {
            time = "00:00:00".split(":");
        }
        GregorianCalendar cal = (GregorianCalendar)Calendar.getInstance();
        cal.clear();
        cal.set(new Integer(date[0]), new Integer(date[1]) - 1, new Integer(date[2]), new Integer(time[0]), new Integer(time[1]), new Integer(time[2]));
        return cal.getTime();
    }
}

