/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce.parse;

import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import com.tek42.perforce.parse.AbstractPerforceTemplate;
import com.tek42.perforce.parse.Builder;
import com.tek42.perforce.process.Executor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPerforceTemplate {
    private static final String[] p4errors = new String[]{"Connect to server failed; check $P4PORT", "Perforce password (P4PASSWD) invalid or unset.", "Password not allowed at this server security level, use 'p4 login'", "Can't create a new user - over license quota.", "Client '*' can only be used from host '*'", "Access for user '", "Your session has expired, please login again.", "You don't have permission for this operation.", "Password invalid."};
    private transient Logger logger;
    private transient String[] errors;
    private final Depot depot;
    final String maxError = "Request too large";

    public AbstractPerforceTemplate(Depot depot) {
        this.depot = depot;
    }

    public Logger getLogger() {
        if (this.depot.getLogger() != null) {
            return this.depot.getLogger();
        }
        return LoggerFactory.getLogger(this.getClass());
    }

    protected List<String> parseList(StringBuilder response, int index) {
        StringTokenizer lines = new StringTokenizer(response.toString(), "\n\r");
        ArrayList<String> list = new ArrayList<String>(100);
        while (lines.hasMoreElements()) {
            StringTokenizer columns = new StringTokenizer(lines.nextToken());
            for (int column = 0; column < index; ++column) {
                columns.nextToken();
            }
            list.add(columns.nextToken());
        }
        return list;
    }

    protected boolean hitMax(StringBuilder response) {
        return response.toString().startsWith("Request too large");
    }

    protected String[] getExtraParams(String[] cmd) {
        String ticket = this.depot.getP4Ticket();
        if (ticket != null) {
            String[] newCmds = new String[cmd.length + 2];
            newCmds[0] = this.getP4Exe();
            newCmds[1] = "-P";
            newCmds[2] = ticket;
            int i = 3;
            while (i - 2 < cmd.length) {
                newCmds[i] = cmd[i - 2];
                ++i;
            }
            cmd = newCmds;
        } else {
            cmd[0] = this.getP4Exe();
        }
        return cmd;
    }

    protected void saveToPerforce(Object object, Builder builder) throws PerforceException {
        boolean loop = false;
        boolean attemptLogin = true;
        do {
            int mesgIndex = -1;
            Executor p4 = this.depot.getExecFactory().newExecutor();
            String debugCmd = "";
            try {
                String line;
                String[] cmds;
                for (String cm : cmds = this.getExtraParams(builder.getSaveCmd(this.getP4Exe(), object))) {
                    debugCmd = debugCmd + cm + " ";
                }
                p4.exec(cmds);
                BufferedReader reader = p4.getReader();
                StringBuilder log = new StringBuilder();
                if (builder.requiresStandardInput()) {
                    BufferedWriter writer = p4.getWriter();
                    1 fwriter = new /* Unavailable Anonymous Inner Class!! */;
                    builder.save(object, (Writer)fwriter);
                    fwriter.flush();
                    fwriter.close();
                }
                StringBuilder error = new StringBuilder();
                StringBuilder info = new StringBuilder();
                int exitCode = 0;
                while ((line = reader.readLine()) != null) {
                    if (mesgIndex == -1) {
                        mesgIndex = this.checkAuthnErrors(line);
                    }
                    if (mesgIndex != -1) {
                        error.append(line);
                        continue;
                    }
                    if (line.startsWith("error")) {
                        if (line.trim().equals("") || line.indexOf("up-to-date") >= 0 || line.indexOf("no file(s) to resolve") >= 0) continue;
                        error.append(line.substring(6));
                        continue;
                    }
                    if (line.startsWith("exit")) {
                        exitCode = Integer.parseInt(line.substring(line.indexOf(" ") + 1, line.length()));
                        continue;
                    }
                    if (line.indexOf(":") > -1) {
                        info.append(line.substring(line.indexOf(":")));
                        continue;
                    }
                    info.append(line);
                }
                reader.close();
                loop = false;
                if ((mesgIndex == 1 || mesgIndex == 2 || mesgIndex == 6) && attemptLogin) {
                    p4.close();
                    this.login();
                    loop = true;
                    attemptLogin = false;
                    mesgIndex = -1;
                } else if (mesgIndex != -1 || exitCode != 0) {
                    if (error.length() != 0) {
                        error.append("\nFor Command: ").append(debugCmd);
                        if (log.length() > 0) {
                            error.append("\nWith Data:\n===================\n");
                            error.append((CharSequence)log);
                            error.append("\n===================\n");
                        }
                        throw new PerforceException(error.toString());
                    }
                    throw new PerforceException(info.toString());
                }
            }
            catch (IOException e) {
                throw new PerforceException("Failed to open connection to perforce", (Throwable)e);
            }
            finally {
                p4.close();
            }
        } while (loop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBuilder getPerforceResponse(String[] cmd) throws PerforceException {
        boolean loop = false;
        boolean attemptLogin = true;
        ArrayList<String> lines = null;
        int totalLength = 0;
        do {
            int mesgIndex = -1;
            int count = 0;
            Executor p4 = this.depot.getExecFactory().newExecutor();
            String debugCmd = "";
            for (String cm : cmd = this.getExtraParams(cmd)) {
                debugCmd = debugCmd + cm + " ";
            }
            p4.exec(cmd);
            BufferedReader reader = p4.getReader();
            String line = null;
            totalLength = 0;
            lines = new ArrayList<String>(1024);
            try {
                while ((line = reader.readLine()) != null) {
                    lines.add(line);
                    totalLength += line.length();
                    ++count;
                    if (mesgIndex != -1) continue;
                    mesgIndex = this.checkAuthnErrors(line);
                }
            }
            catch (IOException ioe) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter((Writer)sw, true);
                ioe.printStackTrace(pw);
                pw.flush();
                sw.flush();
                this.getLogger().warn("Perforce process terminated suddenly");
                this.getLogger().warn(sw.toString());
            }
            finally {
                p4.close();
            }
            loop = false;
            if (attemptLogin && (mesgIndex == 1 || mesgIndex == 2 || mesgIndex == 6)) {
                p4.close();
                this.login();
                loop = true;
                attemptLogin = false;
                continue;
            }
            if (mesgIndex == 4) {
                throw new PerforceException("Access for user '" + this.depot.getUser() + "' has not been enabled by 'p4 protect'");
            }
            if (mesgIndex != -1) {
                throw new PerforceException(p4errors[mesgIndex]);
            }
            if (count != 0) continue;
            throw new PerforceException("No output for: " + debugCmd);
        } while (loop);
        StringBuilder response = new StringBuilder(totalLength + lines.size());
        for (String line : lines) {
            response.append(line);
            response.append("\n");
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getRawPerforceResponseLines(String[] cmd) throws PerforceException {
        ArrayList<String> lines = new ArrayList<String>(1024);
        Executor p4 = this.depot.getExecFactory().newExecutor();
        String debugCmd = "";
        for (String cm : cmd = this.getExtraParams(cmd)) {
            debugCmd = debugCmd + cm + " ";
        }
        p4.exec(cmd);
        try {
            BufferedReader reader = p4.getReader();
            String line = null;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException ioe) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            ioe.printStackTrace(pw);
            pw.flush();
            sw.flush();
            this.getLogger().warn("IOException reading from Perforce process (may just be EOF)");
            this.getLogger().warn(sw.toString());
        }
        finally {
            p4.close();
        }
        return lines;
    }

    protected void login() throws PerforceException {
        try {
            String ticket = null;
            try {
                ticket = this.p4Login(this.getP4Exe());
            }
            catch (PerforceException e) {
                try {
                    ticket = this.p4Login("/usr/bin/p4");
                }
                catch (PerforceException e1) {
                    this.getLogger().warn("Attempt to workaround p4 executable location failed", (Throwable)e1);
                    throw e;
                }
            }
            if (ticket != null) {
                this.getLogger().warn("Using p4 issued ticket.");
                this.depot.setP4Ticket(ticket);
            }
        }
        catch (IOException e) {
            throw new PerforceException("Unable to login via p4 login due to IOException: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String p4Login(String p4Exe) throws IOException, PerforceException {
        Executor login = this.depot.getExecFactory().newExecutor();
        login.exec(new String[]{p4Exe, "login", "-p"});
        try {
            String line;
            BufferedWriter writer = login.getWriter();
            try {
                writer.write(this.depot.getPassword() + "\n");
            }
            finally {
                writer.flush();
            }
            String ticket = null;
            BufferedReader reader = login.getReader();
            while ((line = reader.readLine()) != null) {
                int error = this.checkAuthnErrors(line);
                if (error != -1) {
                    throw new PerforceException("Login attempt failed: " + line);
                }
                ticket = line;
            }
            String string = ticket;
            return string;
        }
        finally {
            login.close();
        }
    }

    private int checkAuthnErrors(String line) {
        for (int i = 0; i < p4errors.length; ++i) {
            if (line.indexOf(p4errors[i]) == -1) continue;
            return i;
        }
        return -1;
    }

    protected String getP4Exe() {
        return this.depot.getExecutable();
    }
}

