/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.api;

import com.perforce.api.EventLog;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Properties;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Debug {
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int NOTICE = 3;
    public static final int VERBOSE = 99;
    public static final int LOG_NONE = 0;
    public static final int LOG_SPLIT = 1;
    public static final int LOG_ONLY = 3;
    private static int level = 0;
    private static EventLog elog = null;
    private static int log_level = 3;
    private static boolean show_thread = false;

    public static String getLevelName(int level) {
        if (0 >= level) {
            return "NONE";
        }
        if (1 >= level) {
            return "ERROR";
        }
        if (2 >= level) {
            return "WARNING";
        }
        if (3 >= level) {
            return "NOTICE";
        }
        return "VERBOSE";
    }

    public static void setDebugLevel(int l) {
        level = l;
    }

    public static int getDebugLevel() {
        return level;
    }

    public static void setShowThread(boolean show) {
        show_thread = show;
    }

    public static boolean getShowThread() {
        return show_thread;
    }

    public static void setEventLog(EventLog elog) {
        Debug.elog = elog;
    }

    public static EventLog getEventLog() {
        return elog;
    }

    public static void setLogLevel(String level) {
        if (level.equalsIgnoreCase("split")) {
            Debug.setLogLevel((int)1);
        } else if (level.equalsIgnoreCase("only")) {
            Debug.setLogLevel((int)3);
        } else {
            Debug.setLogLevel((int)0);
        }
    }

    public static void setProperties(Properties props) {
        String log = props.getProperty("p4.log_level", "none");
        log_level = log.equalsIgnoreCase("split") ? 1 : (log.equalsIgnoreCase("only") ? 3 : 0);
    }

    public static void setLogLevel(int log_level) {
        Debug.log_level = log_level;
        if (0 == Debug.log_level) {
            level = 0;
        }
    }

    public static int getLogLevel() {
        return log_level;
    }

    private static void errLog(String msg, String level) {
        if (null == elog) {
            return;
        }
        elog.log(Debug.getThreadName() + msg, level);
    }

    private static String getThreadName() {
        return show_thread ? Thread.currentThread().getName() + ": " : "";
    }

    public static void error(String msg) {
        if (1 > level) {
            return;
        }
        System.out.println(Debug.getThreadName() + "ERROR: " + msg);
        System.out.flush();
        if (1 <= log_level) {
            Debug.errLog((String)msg, (String)"ERROR");
        }
    }

    public static void warn(String msg) {
        if (2 > level) {
            return;
        }
        if (1 >= log_level) {
            System.out.println(Debug.getThreadName() + "WARNING: " + msg);
            System.out.flush();
        }
        if (1 <= log_level) {
            Debug.errLog((String)msg, (String)"WARNING");
        }
    }

    public static void notify(String msg) {
        if (3 > level) {
            return;
        }
        if (1 >= log_level) {
            System.out.println(Debug.getThreadName() + msg);
            System.out.flush();
        }
        if (1 <= log_level) {
            Debug.errLog((String)msg, (String)"NOTIFY");
        }
    }

    public static void notify(String msg, String[] arry) {
        if (3 > level) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arry.length; ++i) {
            sb.append(arry[i]);
            sb.append(' ');
        }
        if (1 >= log_level) {
            System.out.println(Debug.getThreadName() + msg + sb);
            System.out.flush();
        }
        if (1 <= log_level) {
            Debug.errLog((String)(msg + sb), (String)"NOTIFY");
        }
    }

    public static void verbose(String msg) {
        if (99 > level) {
            return;
        }
        if (1 >= log_level) {
            System.out.println(Debug.getThreadName() + msg);
            System.out.flush();
        }
        if (1 <= log_level) {
            Debug.errLog((String)msg, (String)"VERBOSE");
        }
    }

    public static void verbose(String msg, String[] arry) {
        if (99 > level) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arry.length; ++i) {
            sb.append(arry[i]);
            sb.append(' ');
        }
        if (1 >= log_level) {
            System.out.println(Debug.getThreadName() + msg + sb);
            System.out.flush();
        }
        if (1 <= log_level) {
            Debug.errLog((String)(msg + sb), (String)"VERBOSE");
        }
    }

    public static void out(int level, Throwable t) {
        Debug.out((String)"{0}", (int)level, (Throwable)t);
    }

    public static void out(String format, int level, Throwable t) {
        if (level > Debug.level) {
            return;
        }
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            Object[] args = new Object[]{sw.toString()};
            String msg = MessageFormat.format(format, args);
            if (1 >= log_level) {
                System.out.println(Debug.getThreadName() + msg);
                System.out.flush();
            }
            if (1 <= log_level) {
                Debug.errLog((String)msg, (String)Debug.getLevelName((int)level));
            }
        }
        catch (Exception ex) {
            System.err.println(t);
            System.err.flush();
        }
    }

    public static void out(int level, String msg) {
        if (level > Debug.level) {
            return;
        }
        if (1 >= log_level) {
            System.out.println(Debug.getThreadName() + msg);
            System.out.flush();
        }
        if (1 <= log_level) {
            Debug.errLog((String)msg, (String)Debug.getLevelName((int)level));
        }
    }

    public static void out(int level, String msg, String[] arry) {
        if (level > Debug.level) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arry.length; ++i) {
            sb.append(arry[i]);
            sb.append(' ');
        }
        if (1 >= log_level) {
            System.out.println(Debug.getThreadName() + msg + sb);
            System.out.flush();
        }
        if (1 <= log_level) {
            Debug.errLog((String)(msg + sb), (String)Debug.getLevelName((int)level));
        }
    }
}

