/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.api;

import com.perforce.api.P4Process;
import com.perforce.api.PerforceException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Env {
    private boolean envp_valid = false;
    private String[] envp;
    private Hashtable environ = new Hashtable();
    private Properties props;
    private String p4_exe;
    private String sep_path = null;
    private String sep_file = null;
    private long threshold = 10000L;

    public Env() {
        this.environ.put("P4USER", "robot");
        this.environ.put("P4CLIENT", "robot-client");
        this.environ.put("P4PORT", "localhost:1666");
        this.environ.put("P4PASSWD", "");
        this.environ.put("PATH", "C:\\Program Files\\Perforce");
        this.environ.put("CLASSPATH", "/usr/share/java/p4.jar");
        this.environ.put("SystemDrive", "C:");
        this.environ.put("SystemRoot", "C:\\WINNT");
        this.environ.put("PATHEXT", ".COM;.EXE;.BAT;.CMD");
        this.setFromProperties(new Properties(System.getProperties()));
    }

    public Env(String propfile) throws PerforceException {
        this();
        this.setFromProperties(propfile);
    }

    public Env(Env base) {
        this();
        this.environ = (Hashtable)base.environ.clone();
        this.props = (Properties)base.props.clone();
        this.p4_exe = base.getExecutable();
    }

    public Env(Properties props) {
        this();
        this.setFromProperties(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setenv(String name, String value) {
        if (null == name) {
            return;
        }
        Hashtable hashtable = this.environ;
        synchronized (hashtable) {
            if (null == value) {
                if (name.startsWith("P4")) {
                    this.environ.put(name, "");
                } else {
                    this.environ.remove(name);
                }
            } else {
                this.environ.put(name, value);
            }
        }
        this.envp_valid = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getenv(String name) {
        Hashtable hashtable = this.environ;
        synchronized (hashtable) {
            return (String)this.environ.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getEnvp() {
        if (!this.envp_valid) {
            Hashtable hashtable = this.environ;
            synchronized (hashtable) {
                this.envp = new String[this.environ.size()];
                Enumeration en = this.environ.keys();
                int i = 0;
                while (en.hasMoreElements()) {
                    String var = (String)en.nextElement();
                    this.envp[i++] = var + "=" + this.environ.get(var);
                }
            }
            this.envp_valid = true;
        }
        return this.envp;
    }

    public void checkValidity() throws PerforceException {
        int cnt;
        int msgndx;
        String[] msg;
        block8: {
            msg = new String[]{"Connect to server failed; check $P4PORT", "Perforce password (P4PASSWD) invalid or unset.", "Can't create a new user - over license quota."};
            msgndx = -1;
            cnt = 0;
            P4Process p = null;
            String[] cmd = new String[]{"p4", "user", "-o"};
            try {
                String l;
                p = new P4Process(this);
                p.exec(cmd);
                while (null != (l = p.readLine())) {
                    ++cnt;
                    for (int i = 0; i < msg.length; ++i) {
                        if (-1 == l.indexOf(msg[i])) continue;
                        msgndx = i;
                    }
                }
                p.close();
            }
            catch (IOException ex) {
                if (null == p) break block8;
                try {
                    p.close();
                }
                catch (Exception ignex) {
                    // empty catch block
                }
            }
        }
        if (-1 != msgndx) {
            throw new PerforceException(msg[msgndx]);
        }
        if (0 == cnt) {
            throw new PerforceException("No output from p4 user -o");
        }
    }

    public Vector getPropertyList(String key, String defaultValue) {
        return this.getPropertyList(key, defaultValue, ",");
    }

    public Vector getPropertyList(String key, String defaultValue, String delimeter) {
        Vector<String> v = new Vector<String>();
        String val = this.getProperty(key, defaultValue);
        StringTokenizer st = new StringTokenizer(val, delimeter);
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        return v;
    }

    public Properties getProperties() {
        return new Properties(this.props);
    }

    public String getProperty(String key, String defaultValue) {
        if (null == this.props) {
            return defaultValue;
        }
        return this.props.getProperty(key, defaultValue);
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String setProperty(String key, String value) {
        String val = (String)this.props.setProperty(key, value);
        if (!key.startsWith("p4.")) {
            return val;
        }
        if (key.equals("p4.user")) {
            this.setUser(value);
        } else if (key.equals("p4.client")) {
            this.setClient(value);
        } else if (key.equals("p4.port")) {
            this.setPort(value);
        } else if (key.equals("p4.password")) {
            this.setPassword(value);
        } else if (key.equals("p4.executable")) {
            this.setExecutable(value);
        } else if (key.equals("p4.sysdrive")) {
            this.setSystemDrive(value);
        } else if (key.equals("p4.sysroot")) {
            this.setSystemRoot(value);
        } else if (key.equals("p4.threshold")) {
            try {
                this.setServerTimeout((long)Integer.valueOf(value).intValue());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return val;
    }

    public void setFromProperties(String propfile) throws PerforceException {
        Properties props = new Properties(System.getProperties());
        if (null != propfile) {
            try {
                props.load(new BufferedInputStream(new FileInputStream(propfile)));
                System.setProperties(props);
            }
            catch (Exception e) {
                System.err.println("Unable to load properties.");
                e.printStackTrace(System.err);
                throw new PerforceException("Unable to load properties from " + propfile);
            }
        }
        this.setFromProperties(props);
    }

    public void setFromProperties(Properties props) {
        String windir;
        this.props = props;
        this.sep_path = this.getProperty("path.separator", ";");
        this.sep_file = this.getProperty("file.separator", "/");
        this.setUser(this.getProperty("p4.user", "robot"));
        this.setClient(this.getProperty("p4.client", "robot-client"));
        this.setPort(this.getProperty("p4.port", "localhost:1666"));
        this.setPassword(this.getProperty("p4.password", ""));
        this.setExecutable(this.getProperty("p4.executable", "P4"));
        this.setSystemDrive(this.getProperty("p4.sysdrive", "C:"));
        this.setSystemRoot(this.getProperty("p4.sysroot", "C:\\WINNT"));
        try {
            this.setServerTimeout((long)Integer.valueOf(this.getProperty("p4.threshold", "10000")).intValue());
        }
        catch (Exception ex) {
            // empty catch block
        }
        String os = props.getProperty("os.name");
        if (null == os) {
            return;
        }
        if (os.startsWith("Windows") && null != (windir = props.getProperty("com.ms.windir"))) {
            this.appendPath(windir.substring(0, 1) + "\\Program Files\\Perforce");
            this.setSystemDrive(windir.substring(0, 1));
            this.setSystemRoot(windir);
        }
    }

    public void setUser(String user) {
        if (null == user) {
            return;
        }
        this.environ.put("P4USER", user);
        this.props.setProperty("p4.user", user);
        this.envp_valid = false;
    }

    public String getUser() {
        return (String)this.environ.get("P4USER");
    }

    public void setClient(String client) {
        if (null == client) {
            return;
        }
        this.environ.put("P4CLIENT", client);
        this.props.setProperty("p4.client", client);
        this.envp_valid = false;
    }

    public String getClient() {
        return (String)this.environ.get("P4CLIENT");
    }

    public void setPort(String port) {
        if (null == port) {
            return;
        }
        this.environ.put("P4PORT", port);
        this.props.setProperty("p4.port", port);
        this.envp_valid = false;
    }

    public String getPort() {
        return (String)this.environ.get("P4PORT");
    }

    public void setPassword(String password) {
        if (null == password) {
            return;
        }
        this.environ.put("P4PASSWD", password);
        this.props.setProperty("p4.password", password);
        this.envp_valid = false;
    }

    public String getPassword() {
        return (String)this.environ.get("P4PASSWD");
    }

    public void setPath(String path) {
        if (null == path) {
            return;
        }
        this.environ.put("PATH", path);
        this.props.setProperty("p4.path", path);
        this.envp_valid = false;
    }

    public void appendPath(String path) {
        if (null == path) {
            return;
        }
        String orig_path = (String)this.environ.get("PATH");
        if (null == this.sep_path || null == orig_path) {
            this.setPath(path);
            return;
        }
        StringTokenizer st = new StringTokenizer(orig_path, this.sep_path);
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals(path)) {
                return;
            }
            sb.append(tok);
            sb.append(this.sep_path);
        }
        sb.append(path);
        this.setPath(path);
    }

    public String getPath() {
        return (String)this.environ.get("PATH");
    }

    public void setSystemDrive(String drive) {
        if (null == drive) {
            return;
        }
        this.environ.put("SystemDrive", drive);
        this.props.setProperty("p4.sysdrive", drive);
        this.envp_valid = false;
    }

    public void setSystemRoot(String root) {
        if (null == root) {
            return;
        }
        this.environ.put("SystemRoot", root);
        this.props.setProperty("p4.sysroot", root);
        this.envp_valid = false;
    }

    public void setExecutable(String exe) {
        int pos;
        if (null == exe) {
            return;
        }
        this.p4_exe = exe;
        if (null == this.sep_file) {
            this.sep_file = System.getProperties().getProperty("file.separator", "\\");
        }
        if (-1 == (pos = exe.lastIndexOf(this.sep_file))) {
            return;
        }
        if (null == this.sep_path) {
            this.sep_path = System.getProperties().getProperty("path.separator", ";");
        }
        this.appendPath(exe.substring(0, pos));
        this.props.setProperty("p4.executable", this.p4_exe);
        this.envp_valid = false;
    }

    public String getExecutable() {
        return this.p4_exe;
    }

    public void setServerTimeout(long threshold) {
        this.threshold = threshold;
        this.props.setProperty("p4.threshold", String.valueOf(threshold));
    }

    public long getServerTimeout() {
        return this.threshold;
    }

    public String toString() {
        String[] envp = this.getEnvp();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < envp.length; ++i) {
            sb.append(envp[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer("<env");
        sb.append(" user=\"");
        sb.append(this.getUser());
        sb.append("\" client=\"");
        sb.append(this.getClient());
        sb.append("\" port=\"");
        sb.append(this.getPort());
        sb.append("\" password=\"");
        sb.append(this.getPassword());
        sb.append("\" sysdrive=\"");
        sb.append(this.environ.get("SystemDrive"));
        sb.append("\" sysroot=\"");
        sb.append(this.environ.get("SystemRoot"));
        sb.append("\" threshold=\"");
        sb.append(this.threshold);
        sb.append("\"><executable>");
        sb.append(this.getExecutable());
        sb.append("</executable><path>");
        sb.append(this.getPath());
        sb.append("</path></env>");
        return sb.toString();
    }
}

