/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.performance.PerformanceBuildAction;
import hudson.plugins.performance.PerformanceReport;
import hudson.plugins.performance.UriReport;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class PerformanceReportMap
implements ModelObject {
    private transient PerformanceBuildAction buildAction;
    private static final String PERFORMANCE_REPORTS_DIRECTORY = "performance-reports";
    private static final Logger logger = Logger.getLogger((String)PerformanceReportMap.class.getName());
    private Map<String, PerformanceReport> performanceReportMap = new HashMap();

    PerformanceReportMap() {
    }

    PerformanceReportMap(PerformanceBuildAction buildAction) {
        this.buildAction = buildAction;
    }

    PerformanceReportMap(PerformanceBuildAction buildAction, List<File> pFileList) throws IOException {
        this.buildAction = buildAction;
        for (File pFile : pFileList) {
            this.performanceReportMap.put(pFile.getName(), new PerformanceReport(buildAction, pFile));
        }
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.buildAction.getBuild();
    }

    PerformanceBuildAction getBuildAction() {
        return this.buildAction;
    }

    public String getDisplayName() {
        return "Performance";
    }

    public List<PerformanceReport> getPerformanceListOrdered() {
        Collection uriCollection = this.getPerformanceReportMap().values();
        ArrayList<PerformanceReport> listPerformance = new ArrayList<PerformanceReport>(uriCollection.size());
        for (PerformanceReport performanceReport : uriCollection) {
            listPerformance.add(performanceReport);
        }
        Collections.sort(listPerformance);
        return listPerformance;
    }

    public Map<String, PerformanceReport> getPerformanceReportMap() {
        return this.performanceReportMap;
    }

    public PerformanceReport getPerformanceReport(String performanceReportName) {
        PerformanceReport meterReport = null;
        if (this.performanceReportMap == null || this.performanceReportMap.get(performanceReportName) == null || this.performanceReportMap.get(performanceReportName) == null) {
            File reportFile = new File(this.getBuild().getRootDir(), PerformanceReportMap.getPerformanceReportFileRelativePath((String)performanceReportName));
            try {
                meterReport = new PerformanceReport(this.buildAction, reportFile);
                if (meterReport.size() == 0) {
                    logger.warn((Object)"Performance report analysis is empty, ensure your jtl file is filled with samples.");
                }
                if (this.performanceReportMap == null) {
                    this.performanceReportMap = new HashMap();
                }
                this.performanceReportMap.put(performanceReportName, meterReport);
            }
            catch (IOException e) {
                logger.warn((Object)("Failed to load " + reportFile), (Throwable)e);
                Throwable ex = e;
                do {
                    logger.warn((Object)ex.getLocalizedMessage());
                } while ((ex = ex.getCause()) != null);
            }
        } else {
            meterReport = (PerformanceReport)this.performanceReportMap.get(performanceReportName);
        }
        return meterReport;
    }

    public UriReport getUriReport(String uriReport) {
        if (uriReport != null) {
            String uriReportDecoded;
            try {
                uriReportDecoded = URLDecoder.decode(uriReport.replace(UriReport.END_PERFORMANCE_PARAMETER, ""), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
            StringTokenizer st = new StringTokenizer(uriReportDecoded, ";");
            return (UriReport)((PerformanceReport)this.getPerformanceReportMap().get(st.nextToken())).getUriReportMap().get(st.nextToken());
        }
        return null;
    }

    public String getUrlName() {
        return "performanceReportList";
    }

    void setBuildAction(PerformanceBuildAction buildAction) {
        this.buildAction = buildAction;
    }

    public void setPerformanceReportMap(Map<String, PerformanceReport> performanceReportMap) {
        this.performanceReportMap = performanceReportMap;
    }

    public static String getPerformanceReportFileRelativePath(String reportFileName) {
        return PerformanceReportMap.getRelativePath((String)reportFileName);
    }

    public static String getPerformanceReportDirRelativePath() {
        return PerformanceReportMap.getRelativePath(null);
    }

    private static String getRelativePath(String reportFileName) {
        StringBuilder sb = new StringBuilder(100);
        sb.append("performance-reports");
        if (reportFileName != null) {
            sb.append("/").append(reportFileName);
        }
        return sb.toString();
    }

    public boolean isFailed(String performanceReportName) {
        return this.getPerformanceReport(performanceReportName) == null;
    }
}

