/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.plugins.performance.PerformanceReportMap;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.kohsuke.stapler.StaplerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceBuildAction
implements Action,
StaplerProxy {
    private static final long serialVersionUID = 1L;
    private final AbstractBuild<?, ?> build;
    private final transient PrintStream hudsonConsoleWriter;
    private transient WeakReference<PerformanceReportMap> performanceReportMap;
    private static final Logger logger = Logger.getLogger((String)PerformanceBuildAction.class.getName());

    public PerformanceBuildAction(AbstractBuild<?, ?> pBuild, PrintStream logger) {
        this.build = pBuild;
        this.hudsonConsoleWriter = logger;
        this.performanceReportMap = new WeakReference<PerformanceReportMap>(new PerformanceReportMap(this));
    }

    public String getDisplayName() {
        return "Performance report";
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return "performance";
    }

    public Object getTarget() {
        File repo = new File(this.build.getRootDir(), PerformanceReportMap.getPerformanceReportDirRelativePath());
        ArrayList<File> pFileList = new ArrayList<File>(0);
        for (File file : repo.listFiles()) {
            pFileList.add(file);
        }
        PerformanceReportMap jmList = null;
        try {
            jmList = new PerformanceReportMap(this, pFileList);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return jmList;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    PrintStream getHudsonConsoleWriter() {
        return this.hudsonConsoleWriter;
    }

    public WeakReference<PerformanceReportMap> getPerformanceReportMap() {
        if (this.performanceReportMap == null || this.performanceReportMap.get() == null) {
            PerformanceReportMap reportMap = new PerformanceReportMap(this);
            this.performanceReportMap = new WeakReference<PerformanceReportMap>(reportMap);
        }
        return this.performanceReportMap;
    }

    public void setPerformanceReportMap(WeakReference<PerformanceReportMap> performanceReportMap) {
        this.performanceReportMap = performanceReportMap;
    }
}

