/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.performance.PerformanceBuildAction;
import hudson.plugins.performance.PerformanceProjectAction;
import hudson.plugins.performance.PerformanceReportMap;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformancePublisher
extends Recorder {
    public static final BuildStepDescriptor<Publisher> DESCRIPTOR = new DescriptorImpl();
    private int errorFailedThreshold = 0;
    private int errorUnstableThreshold = 0;
    private String filename;

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public static File getPerformanceReport(AbstractBuild<?, ?> build, String performanceReportName) {
        return new File(build.getRootDir(), PerformanceReportMap.getPerformanceReportFileRelativePath(PerformancePublisher.getPerformanceReportBuildFileName(performanceReportName)));
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new PerformanceProjectAction(project);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public static String getPerformanceReportBuildFileName(String performanceReportWorkspaceName) {
        Pattern p;
        Matcher matcher;
        String result = performanceReportWorkspaceName;
        if (performanceReportWorkspaceName != null && (matcher = (p = Pattern.compile("-[0-9]*\\.xml")).matcher(performanceReportWorkspaceName)).find()) {
            result = matcher.replaceAll(".xml");
        }
        return result;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        logger.println("Recording Performance reports " + this.getFilename());
        List<String> filenameList = this.manageFilename(this.filename);
        boolean result = true;
        PerformanceBuildAction performanceBuildAction = new PerformanceBuildAction(build, logger);
        build.addAction((Action)performanceBuildAction);
        for (String filename : filenameList) {
            if (filename.compareTo("") == 0) continue;
            FilePath src = build.getWorkspace().child(filename);
            if (!src.exists()) {
                if (build.getResult().isWorseThan(Result.UNSTABLE)) {
                    return true;
                }
                build.setResult(Result.FAILURE);
                logger.println("Performance file " + src + " not found. Has the report generated? Setting Build to " + build.getResult().toString());
                return true;
            }
            if (!src.isDirectory()) {
                result = result && this.manageOnePerformanceReport(build, src, performanceBuildAction, logger) != false;
                continue;
            }
            List listSrc = new ArrayList(0);
            listSrc = src.list();
            Boolean resultManage = true;
            ArrayList<String> performanceReportListNameFile = new ArrayList<String>(listSrc.size());
            for (FilePath filePath : listSrc) {
                resultManage = resultManage != false && this.manageOnePerformanceReport(build, filePath, performanceBuildAction, logger) != false;
                performanceReportListNameFile.add(PerformancePublisher.getPerformanceReportBuildFileName(filePath.getName()));
            }
            result = result && resultManage != false;
        }
        return result;
    }

    private Boolean manageOnePerformanceReport(AbstractBuild<?, ?> build, FilePath src, PerformanceBuildAction performanceBuildAction, PrintStream logger) throws IOException, InterruptedException {
        File localReport = PerformancePublisher.getPerformanceReport(build, src.getName());
        if (!localReport.getParentFile().exists()) {
            localReport.getParentFile().mkdirs();
        }
        if (src.isDirectory()) {
            logger.println("File : " + src.getName() + " is a directory, ant not a Performance Report");
            return true;
        }
        src.copyTo(new FilePath(localReport));
        if (((PerformanceReportMap)performanceBuildAction.getPerformanceReportMap().get()).isFailed(PerformancePublisher.getPerformanceReportBuildFileName(src.getName()))) {
            build.setResult(Result.UNSTABLE);
            logger.println("Performance report analysis failed. Setting Build to " + build.getResult().toString());
            return true;
        }
        if (this.errorUnstableThreshold > 0 && this.errorUnstableThreshold < 100) {
            logger.println("Performance's percentage error greater or equal than " + this.errorUnstableThreshold + "% sets the build as " + Result.UNSTABLE.toString().toLowerCase());
        }
        if (this.errorFailedThreshold > 0 && this.errorFailedThreshold < 100) {
            logger.println("Performance's percentage error greater or equal than " + this.errorFailedThreshold + "% sets the build as " + Result.FAILURE.toString().toLowerCase());
        }
        double errorPercent = ((PerformanceReportMap)performanceBuildAction.getPerformanceReportMap().get()).getPerformanceReport(PerformancePublisher.getPerformanceReportBuildFileName(src.getName())).errorPercent();
        if (this.errorFailedThreshold > 0 && errorPercent >= (double)this.errorFailedThreshold) {
            build.setResult(Result.FAILURE);
        } else if (this.errorUnstableThreshold > 0 && errorPercent >= (double)this.errorUnstableThreshold && build.getResult() != Result.FAILURE) {
            build.setResult(Result.UNSTABLE);
        }
        logger.println("Performance has reported a " + errorPercent + "% of errors running the tests. Setting Build to " + build.getResult().toString());
        return true;
    }

    private List<String> manageFilename(String filename) {
        StringTokenizer st = new StringTokenizer(filename, ";");
        ArrayList<String> filenameList = new ArrayList<String>(0);
        while (st.hasMoreTokens()) {
            filenameList.add(st.nextToken());
        }
        Collections.sort(filenameList);
        return filenameList;
    }

    public int getErrorFailedThreshold() {
        return this.errorFailedThreshold;
    }

    public void setErrorFailedThreshold(int errorFailedThreshold) {
        this.errorFailedThreshold = Math.max(0, Math.min(errorFailedThreshold, 100));
    }

    public int getErrorUnstableThreshold() {
        return this.errorUnstableThreshold;
    }

    public void setErrorUnstableThreshold(int errorUnstableThreshold) {
        this.errorUnstableThreshold = Math.max(0, Math.min(errorUnstableThreshold, 100));
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(PerformancePublisher.class);
        }

        public String getDisplayName() {
            return "Publish Performance test result report";
        }

        public String getHelpFile() {
            return "/plugin/performance/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            PerformancePublisher performancePublisher = new PerformancePublisher();
            req.bindParameters((Object)performancePublisher, "performance.");
            return performancePublisher;
        }
    }
}

