/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.model.AbstractBuild;
import hudson.plugins.performance.HttpSample;
import hudson.plugins.performance.Messages;
import hudson.plugins.performance.PerformanceBuildAction;
import hudson.plugins.performance.UriReport;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceReport
extends DefaultHandler
implements Comparable<PerformanceReport> {
    private PerformanceBuildAction buildAction;
    private HttpSample httpSample;
    private String reportFileName = null;
    private final Map<String, UriReport> uriReportMap = new HashMap();
    private static HttpSample currentSample;
    private static int status;

    PerformanceReport() {
    }

    PerformanceReport(PerformanceBuildAction buildAction, File pFile) throws IOException {
        this.buildAction = buildAction;
        this.reportFileName = pFile.getName();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(pFile, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            throw new IOException2("Failed to create parser ", (Throwable)e);
        }
        catch (SAXException e) {
            throw new IOException2("Failed to parse " + pFile, (Throwable)e);
        }
    }

    public void addSample(HttpSample pHttpSample) throws SAXException {
        String uri = pHttpSample.getUri();
        if (uri == null) {
            this.buildAction.getHudsonConsoleWriter().println("label cannot be empty, please ensure your jmx file specifies name properly for each http sample: skipping sample");
            return;
        }
        String staplerUri = uri.replace("http:", "").replaceAll("/", "_");
        UriReport uriReport = (UriReport)this.uriReportMap.get(staplerUri);
        if (uriReport == null) {
            uriReport = new UriReport(this, staplerUri, uri);
            this.uriReportMap.put(staplerUri, uriReport);
        }
        uriReport.addHttpSample(pHttpSample);
    }

    @Override
    public int compareTo(PerformanceReport jmReport) {
        if (this == jmReport) {
            return 0;
        }
        return this.getReportFileName().compareTo(jmReport.getReportFileName());
    }

    public int countErrors() {
        int nbError = 0;
        for (UriReport currentReport : this.uriReportMap.values()) {
            nbError += currentReport.countErrors();
        }
        return nbError;
    }

    public double errorPercent() {
        return (double)this.countErrors() / (double)this.size() * 100.0;
    }

    public long getAverage() {
        long result = 0L;
        int size = this.size();
        if (size != 0) {
            long average = 0L;
            for (UriReport currentReport : this.uriReportMap.values()) {
                average += currentReport.getAverage() * (long)currentReport.size();
            }
            result = average / (long)size;
        }
        return result;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.buildAction.getBuild();
    }

    PerformanceBuildAction getBuildAction() {
        return this.buildAction;
    }

    public String getDisplayName() {
        return Messages.Report_DisplayName();
    }

    public UriReport getDynamic(String token, StaplerRequest req, StaplerResponse rsp) throws IOException {
        return (UriReport)this.getUriReportMap().get(token);
    }

    public HttpSample getHttpSample() {
        return this.httpSample;
    }

    public long getMax() {
        long max = Long.MIN_VALUE;
        for (UriReport currentReport : this.uriReportMap.values()) {
            max = Math.max(currentReport.getMax(), max);
        }
        return max;
    }

    public long getMin() {
        long min = Long.MAX_VALUE;
        for (UriReport currentReport : this.uriReportMap.values()) {
            min = Math.min(currentReport.getMin(), min);
        }
        return min;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public List<UriReport> getUriListOrdered() {
        Collection uriCollection = this.getUriReportMap().values();
        ArrayList<UriReport> UriReportList = new ArrayList<UriReport>(uriCollection);
        Collections.sort(UriReportList);
        return UriReportList;
    }

    public Map<String, UriReport> getUriReportMap() {
        return this.uriReportMap;
    }

    void setBuildAction(PerformanceBuildAction buildAction) {
        this.buildAction = buildAction;
    }

    public void setHttpSample(HttpSample httpSample) {
        this.httpSample = httpSample;
    }

    public void setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName;
    }

    public int size() {
        int size = 0;
        for (UriReport currentReport : this.uriReportMap.values()) {
            size += currentReport.size();
        }
        return size;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("httpSample".equalsIgnoreCase(qName) || "sample".equalsIgnoreCase(qName)) {
            HttpSample sample = new HttpSample();
            sample.setDate(new Date(Long.valueOf(attributes.getValue("ts") != null ? attributes.getValue("ts") : attributes.getValue("timeStamp"))));
            sample.setDuration(Long.valueOf(attributes.getValue("t") != null ? attributes.getValue("t") : attributes.getValue("time")).longValue());
            sample.setSuccessful(Boolean.valueOf(attributes.getValue("s") != null ? attributes.getValue("s") : attributes.getValue("success")).booleanValue());
            sample.setUri(attributes.getValue("lb") != null ? attributes.getValue("lb") : attributes.getValue("label"));
            this.addSample(sample);
        } else if ("testcase".equalsIgnoreCase(qName)) {
            if (status != 0) {
                this.addSample(currentSample);
            }
            status = 1;
            currentSample = new HttpSample();
            currentSample.setDate(new Date(0L));
            String time = attributes.getValue("time");
            StringTokenizer st = new StringTokenizer(time, ".");
            ArrayList<String> listTime = new ArrayList<String>(2);
            while (st.hasMoreTokens()) {
                listTime.add(st.nextToken());
            }
            currentSample.setDuration(Long.valueOf((String)listTime.get(0)).longValue());
            currentSample.setSuccessful(true);
            currentSample.setUri(attributes.getValue("name"));
        } else if ("failure".equalsIgnoreCase(qName) && status != 0) {
            currentSample.setSuccessful(false);
            this.addSample(currentSample);
            status = 0;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (("testsuite".compareToIgnoreCase(qName) == 0 || "testcase".compareToIgnoreCase(qName) == 0) && status != 0) {
            this.addSample(currentSample);
            status = 0;
        }
    }
}

