/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.performance.Messages;
import hudson.plugins.performance.PerformanceBuildAction;
import hudson.plugins.performance.PerformanceProjectAction;
import hudson.plugins.performance.PerformanceReportMap;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformancePublisher
extends Recorder {
    public static final BuildStepDescriptor<Publisher> DESCRIPTOR = new DescriptorImpl();
    private int errorFailedThreshold = 0;
    private int errorUnstableThreshold = 0;
    private String filename;

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public static File getPerformanceReport(AbstractBuild<?, ?> build, String performanceReportName) {
        return new File(build.getRootDir(), PerformanceReportMap.getPerformanceReportFileRelativePath(PerformancePublisher.getPerformanceReportBuildFileName(performanceReportName)));
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new PerformanceProjectAction(project);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public static String getPerformanceReportBuildFileName(String performanceReportWorkspaceName) {
        Pattern p;
        Matcher matcher;
        String result = performanceReportWorkspaceName;
        if (performanceReportWorkspaceName != null && (matcher = (p = Pattern.compile("-[0-9]*\\.xml")).matcher(performanceReportWorkspaceName)).find()) {
            result = matcher.replaceAll(".xml");
        }
        return result;
    }

    protected static FilePath[] locatePerformanceReports(FilePath workspace, String includes) throws IOException, InterruptedException {
        String[] parts;
        try {
            FilePath[] ret = workspace.list(includes);
            if (ret.length > 0) {
                return ret;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        for (String path : parts = includes.split("\\s*[;:,]+\\s*")) {
            FilePath src = workspace.child(path);
            if (!src.exists()) continue;
            if (src.isDirectory()) {
                files.addAll(Arrays.asList(src.list("**/*")));
                continue;
            }
            files.add(src);
        }
        return files.toArray(new FilePath[files.size()]);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        if (this.filename == null || this.filename.length() == 0) {
            this.filename = "**/*.jtl";
        }
        logger.println("Performance: Recording reports [" + this.filename + "]");
        FilePath[] files = PerformancePublisher.locatePerformanceReports(build.getWorkspace(), this.filename);
        if (files.length == 0) {
            if (build.getResult().isWorseThan(Result.UNSTABLE)) {
                return true;
            }
            build.setResult(Result.FAILURE);
            logger.println("Performance: no files matching '" + this.filename + "' have been found. Has the report generated?. Setting Build to " + build.getResult().toString());
            return true;
        }
        if (this.errorUnstableThreshold > 0 && this.errorUnstableThreshold < 100) {
            logger.println("Performance: Percentage of errors greater or equal than " + this.errorUnstableThreshold + "% sets the build as " + Result.UNSTABLE.toString().toLowerCase());
        } else {
            logger.println("Performance: No threshold configured for making the test " + Result.UNSTABLE.toString().toLowerCase());
        }
        if (this.errorFailedThreshold > 0 && this.errorFailedThreshold < 100) {
            logger.println("Performance: Percentage of errors greater or equal than " + this.errorFailedThreshold + "% sets the build as " + Result.FAILURE.toString().toLowerCase());
        } else {
            logger.println("Performance: No threshold configured for making the test " + Result.FAILURE.toString().toLowerCase());
        }
        Boolean resultManage = true;
        PerformanceBuildAction performanceBuildAction = new PerformanceBuildAction(build, logger);
        build.addAction((Action)performanceBuildAction);
        ArrayList<String> performanceReportListNameFile = new ArrayList<String>(files.length);
        for (FilePath filePath : files) {
            resultManage = resultManage != false && this.manageOnePerformanceReport(build, filePath, performanceBuildAction, logger) != false;
            performanceReportListNameFile.add(PerformancePublisher.getPerformanceReportBuildFileName(filePath.getName()));
        }
        return resultManage;
    }

    private Boolean manageOnePerformanceReport(AbstractBuild<?, ?> build, FilePath src, PerformanceBuildAction performanceBuildAction, PrintStream logger) throws IOException, InterruptedException {
        logger.println("Performance: Parsing report file " + src.getName());
        File localReport = PerformancePublisher.getPerformanceReport(build, src.getName());
        if (!localReport.getParentFile().exists()) {
            localReport.getParentFile().mkdirs();
        }
        if (src.isDirectory()) {
            logger.println("Performance: File '" + src.getName() + "' is a directory, not a Performance Report");
            return true;
        }
        src.copyTo(new FilePath(localReport));
        if (((PerformanceReportMap)performanceBuildAction.getPerformanceReportMap().get()).isFailed(PerformancePublisher.getPerformanceReportBuildFileName(src.getName()))) {
            build.setResult(Result.UNSTABLE);
            logger.println("Performance: Report analysis failed. Setting Build to " + build.getResult().toString());
            return true;
        }
        double errorPercent = ((PerformanceReportMap)performanceBuildAction.getPerformanceReportMap().get()).getPerformanceReport(PerformancePublisher.getPerformanceReportBuildFileName(src.getName())).errorPercent();
        if (this.errorFailedThreshold > 0 && errorPercent >= (double)this.errorFailedThreshold) {
            build.setResult(Result.FAILURE);
        } else if (this.errorUnstableThreshold > 0 && errorPercent >= (double)this.errorUnstableThreshold && build.getResult() != Result.FAILURE) {
            build.setResult(Result.UNSTABLE);
        }
        logger.println("Performance: Reported a " + errorPercent + "% of errors during the tests. Build status is: " + build.getResult().toString());
        return true;
    }

    private List<String> manageFilename(String filename) {
        StringTokenizer st = new StringTokenizer(filename, ";");
        ArrayList<String> filenameList = new ArrayList<String>(0);
        while (st.hasMoreTokens()) {
            filenameList.add(st.nextToken());
        }
        Collections.sort(filenameList);
        return filenameList;
    }

    public int getErrorFailedThreshold() {
        return this.errorFailedThreshold;
    }

    public void setErrorFailedThreshold(int errorFailedThreshold) {
        this.errorFailedThreshold = Math.max(0, Math.min(errorFailedThreshold, 100));
    }

    public int getErrorUnstableThreshold() {
        return this.errorUnstableThreshold;
    }

    public void setErrorUnstableThreshold(int errorUnstableThreshold) {
        this.errorUnstableThreshold = Math.max(0, Math.min(errorUnstableThreshold, 100));
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(PerformancePublisher.class);
        }

        public String getDisplayName() {
            return Messages.Publisher_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/performance/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            PerformancePublisher performancePublisher = new PerformancePublisher();
            req.bindParameters((Object)performancePublisher, "performance.");
            return performancePublisher;
        }
    }
}

