/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.kohsuke.stapler.Stapler;

public abstract class AbstractReport {
    private NumberFormat percentFormat;
    private NumberFormat dataFormat;

    public abstract int countErrors();

    public abstract double errorPercent();

    public AbstractReport() {
        if (Stapler.getCurrentRequest() != null) {
            Locale.setDefault(Stapler.getCurrentRequest().getLocale());
        }
        this.percentFormat = new DecimalFormat("0.0");
        this.dataFormat = new DecimalFormat("#,###");
    }

    public String errorPercentFormated() {
        Stapler.getCurrentRequest().getLocale();
        return this.percentFormat.format(this.errorPercent());
    }

    public abstract long getAverage();

    public String getAverageFormated() {
        return this.dataFormat.format(this.getAverage());
    }

    public abstract long getMax();

    public String getMaxFormated() {
        return this.dataFormat.format(this.getMax());
    }

    public abstract long getMin();

    public abstract int size();
}

