/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.performance.JMeterParser;
import hudson.plugins.performance.PerformanceReport;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitParser
extends JMeterParser {
    @DataBoundConstructor
    public JUnitParser(String glob) {
        super(glob);
    }

    public String getDefaultGlobPattern() {
        return "**/TEST-*.xml";
    }

    public Collection<PerformanceReport> parse(AbstractBuild<?, ?> build, Collection<File> reports, TaskListener listener) throws IOException {
        ArrayList<PerformanceReport> result = new ArrayList<PerformanceReport>();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        PrintStream logger = listener.getLogger();
        for (File f : reports) {
            try {
                SAXParser parser = factory.newSAXParser();
                PerformanceReport r = new PerformanceReport();
                r.setReportFileName(f.getName());
                logger.println("Performance: Parsing JUnit report file " + f.getName());
                parser.parse(f, (DefaultHandler)new /* Unavailable Anonymous Inner Class!! */);
                result.add(r);
            }
            catch (ParserConfigurationException e) {
                throw new IOException2("Failed to create parser ", (Throwable)e);
            }
            catch (SAXException e) {
                logger.println("Performance: Failed to parse " + f + ": " + e.getMessage());
            }
        }
        return result;
    }
}

