/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.persona.simple;

import hudson.Extension;
import hudson.ExtensionComponent;
import hudson.ExtensionFinder;
import hudson.FilePath;
import hudson.PluginWrapper;
import hudson.model.Hudson;
import hudson.plugins.persona.Persona;
import hudson.plugins.persona.simple.SimplePersona;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class SimplePersonaFinder
extends ExtensionFinder {
    private static final String[] EXTENSIONS = new String[]{".jpg", ".jpeg", ".png", ".gif", ".JPG", ".JPEG", ".PNG", ".GIF"};
    private static final Logger LOGGER = Logger.getLogger(SimplePersonaFinder.class.getName());

    public <T> Collection<ExtensionComponent<T>> find(Class<T> type, Hudson hudson) {
        if (type != Persona.class) {
            return Collections.emptyList();
        }
        ArrayList<ExtensionComponent<T>> r = new ArrayList<ExtensionComponent<T>>();
        try {
            FilePath baseDir = new FilePath(hudson.getRootDir());
            for (FilePath xml : baseDir.list("persona/**/*.xml")) {
                URL url = xml.toURI().toURL();
                this.parsePersonaInto(url, xml.getParent().toURI().toURL(), xml.getParent().getRemote().substring(baseDir.getRemote().length() + 1), r);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to load personas", e);
        }
        catch (InterruptedException e) {
            throw new Error(e);
        }
        for (PluginWrapper pw : hudson.getPluginManager().getPlugins()) {
            URL xml;
            try {
                xml = new URL(pw.baseResourceURL, "persona.xml");
                xml.openStream().close();
            }
            catch (IOException e) {
                continue;
            }
            this.parsePersonaInto(xml, pw.baseResourceURL, "plugin/" + pw.getShortName(), r);
        }
        return r;
    }

    private String findImage(URL imageBase, String imageBasePath, String baseName) throws IOException {
        for (String ext : EXTENSIONS) {
            try {
                new URL(imageBase, baseName + ext).openStream().close();
                return imageBasePath + '/' + baseName + ext;
            }
            catch (IOException e) {
            }
        }
        throw new IOException("No image found that matches " + imageBase + "/" + baseName + ".*");
    }

    private void parsePersonaInto(URL xml, URL imageBase, String imageBasePath, Collection<ExtensionComponent<SimplePersona>> result) {
        try {
            result.add((ExtensionComponent<SimplePersona>)new ExtensionComponent((Object)this.parsePersona(xml, imageBase, imageBasePath)));
        }
        catch (DocumentException e) {
            LOGGER.log(Level.SEVERE, "Faied to load a persona from " + xml, e);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Faied to load a persona from " + xml, e);
        }
    }

    private SimplePersona parsePersona(URL xml, URL imageBase, String imageBasePath) throws DocumentException, IOException {
        Document d = new SAXReader().read(xml);
        Element r = d.getRootElement();
        ArrayList<String> quotes = new ArrayList<String>();
        for (Element e : r.elements("quote")) {
            quotes.add(e.getTextTrim());
        }
        String displayName = r.attributeValue("displayName");
        String icon = this.findImage(imageBase, imageBasePath, "icon");
        String success = this.findImage(imageBase, imageBasePath, "success");
        String failure = this.findImage(imageBase, imageBasePath, "failure");
        String other = this.findImage(imageBase, imageBasePath, "other");
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

