/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.persona.xml;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.persona.simple.Image;
import hudson.plugins.persona.simple.SimplePersona;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBasedPersona
extends SimplePersona {
    public final URL xml;
    private final URL imageBase;
    private final String imageBasePath;
    private String icon;
    private String success;
    private String failure;
    private String other;
    private String displayName;
    private static final String[] EXTENSIONS = new String[]{".jpg", ".jpeg", ".png", ".gif", ".JPG", ".JPEG", ".PNG", ".GIF"};

    public static XmlBasedPersona create(URL xml, URL imageBase, String imageBasePath) throws DocumentException, IOException {
        Element r = new SAXReader().read(xml).getRootElement();
        return new XmlBasedPersona(r, xml, imageBase, imageBasePath);
    }

    private XmlBasedPersona(Element r, URL xml, URL imageBase, String imageBasePath) throws IOException, DocumentException {
        super(r.attributeValue("id"), new ArrayList());
        this.xml = xml;
        this.imageBase = imageBase;
        this.imageBasePath = imageBasePath;
        this.reload();
    }

    private String findImage(URL imageBase, String imageBasePath, String baseName) throws IOException {
        for (String ext : EXTENSIONS) {
            try {
                new URL(imageBase, baseName + ext).openStream().close();
                return imageBasePath + '/' + baseName + ext;
            }
            catch (IOException e) {
            }
        }
        throw new IOException("No image found that matches " + imageBase + "/" + baseName + ".*");
    }

    public void reload() throws IOException, DocumentException {
        this.icon = this.findImage(this.imageBase, this.imageBasePath, "icon");
        this.success = this.findImage(this.imageBase, this.imageBasePath, "success");
        this.failure = this.findImage(this.imageBase, this.imageBasePath, "failure");
        this.other = this.findImage(this.imageBase, this.imageBasePath, "other");
        Element r = new SAXReader().read(this.xml).getRootElement();
        this.displayName = r.attributeValue("displayName");
        ArrayList<String> quotes = new ArrayList<String>();
        for (Element e : r.elements("quote")) {
            quotes.add(e.getTextTrim());
        }
        this.setQuotes(quotes);
    }

    public Image getImage(AbstractBuild<?, ?> build) {
        Result r = build.getResult();
        if (r == Result.SUCCESS) {
            return new Image(this.icon, this.success);
        }
        if (r == Result.FAILURE) {
            return new Image(this.icon, this.failure);
        }
        return new Image(this.icon, this.other);
    }

    public Image getDefaultImage() {
        return new Image(this.icon, this.success);
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

