/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.persona;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.plugins.persona.Persona;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.ListBoxModel;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuotePublisher
extends Notifier {
    public final Persona persona;

    @DataBoundConstructor
    public QuotePublisher(String personaId) {
        this.persona = Persona.byId(personaId);
    }

    public String getPersonaId() {
        return this.persona != null ? this.persona.id : null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return this.persona != null ? this.persona.generateProjectQuote(project) : null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.persona != null) {
            build.getActions().add(this.persona.generateQuote(build));
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Associate Persona";
        }

        public ListBoxModel doFillPersonaIdItems() {
            ListBoxModel r = new ListBoxModel();
            for (Persona p : Persona.all()) {
                r.add(p.getDisplayName(), p.id);
            }
            return r;
        }
    }
}

