/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.persona.xml;

import hudson.Extension;
import hudson.ExtensionComponent;
import hudson.ExtensionFinder;
import hudson.FilePath;
import hudson.PluginWrapper;
import hudson.model.Hudson;
import hudson.plugins.persona.Persona;
import hudson.plugins.persona.xml.XmlBasedPersona;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dom4j.DocumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class XmlPersonaFinder
extends ExtensionFinder {
    private static final Logger LOGGER = Logger.getLogger(XmlPersonaFinder.class.getName());

    public <T> Collection<ExtensionComponent<T>> find(Class<T> type, Hudson hudson) {
        if (type != Persona.class) {
            return Collections.emptyList();
        }
        ArrayList<ExtensionComponent<XmlBasedPersona>> r = new ArrayList<ExtensionComponent<XmlBasedPersona>>();
        try {
            FilePath baseDir = new FilePath(hudson.getRootDir());
            for (FilePath xml : baseDir.list("persona/**/*.xml")) {
                URL url = xml.toURI().toURL();
                this.parsePersonaInto(url, xml.getParent().toURI().toURL(), xml.getParent().getRemote().substring(baseDir.getRemote().length() + 1).replace('\\', '/'), r);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to load personas", e);
        }
        catch (InterruptedException e) {
            throw new Error(e);
        }
        for (PluginWrapper pw : hudson.getPluginManager().getPlugins()) {
            URL xml;
            try {
                xml = new URL(pw.baseResourceURL, "persona.xml");
                xml.openStream().close();
            }
            catch (IOException e) {
                continue;
            }
            this.parsePersonaInto(xml, pw.baseResourceURL, "plugin/" + pw.getShortName(), r);
        }
        return r;
    }

    private void parsePersonaInto(URL xml, URL imageBase, String imageBasePath, Collection<ExtensionComponent<XmlBasedPersona>> result) {
        try {
            result.add((ExtensionComponent<XmlBasedPersona>)new ExtensionComponent((Object)XmlBasedPersona.create(xml, imageBase, imageBasePath)));
        }
        catch (DocumentException e) {
            LOGGER.log(Level.SEVERE, "Faied to load a persona from " + xml, e);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Faied to load a persona from " + xml, e);
        }
    }
}

