/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.phing;

import hudson.StructuredForm;
import hudson.model.Descriptor;
import hudson.plugins.phing.Messages;
import hudson.plugins.phing.PhingBuilder;
import hudson.plugins.phing.PhingInstallation;
import hudson.tasks.Builder;
import hudson.util.FormFieldValidator;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PhingDescriptor
extends Descriptor<Builder> {
    private volatile PhingInstallation[] installations = new PhingInstallation[0];

    public PhingDescriptor() {
        super(PhingBuilder.class);
        this.load();
    }

    public boolean configure(StaplerRequest req) throws Descriptor.FormException {
        List list = req.bindJSONToList(PhingInstallation.class, StructuredForm.get((StaplerRequest)req).get("phing"));
        this.installations = list.toArray(new PhingInstallation[list.size()]);
        this.save();
        return true;
    }

    public void convert(Map<String, Object> oldPropertyBag) {
        if (oldPropertyBag.containsKey("installations")) {
            this.installations = (PhingInstallation[])oldPropertyBag.get("installations");
        }
    }

    public String getHelpFile() {
        return "/plugin/phing/help.html";
    }

    public String getDisplayName() {
        return Messages.Phing_DisplayName();
    }

    public PhingInstallation[] getInstallations() {
        return this.installations;
    }

    public PhingBuilder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        return (PhingBuilder)((Object)req.bindJSON(PhingBuilder.class, formData));
    }

    public void doCheckPhingHome(StaplerRequest req, StaplerResponse res) throws IOException, ServletException {
        new FormFieldValidator(req, res, true){

            protected void check() throws IOException, ServletException {
                File f = this.getFileParameter("value");
                if ("".equals(f.getPath().trim())) {
                    this.error(Messages.Phing_PhingHomeRequired());
                    return;
                }
                if (!f.isDirectory()) {
                    this.error(Messages.Phing_NotAPHPCommand(f));
                    return;
                }
                File phing = new File(f, "bin" + File.separator + "phing.php");
                if (!phing.exists()) {
                    this.error(Messages.Phing_NotAPhingDirectory(f));
                    return;
                }
                this.ok();
            }
        }.process();
    }

    public void doCheckPhpCommand(StaplerRequest req, StaplerResponse res) throws IOException, ServletException {
        new FormFieldValidator(req, res, true){

            protected void check() throws IOException, ServletException {
                File f = this.getFileParameter("value");
                if ("".equals(f.getPath().trim())) {
                    this.ok();
                    return;
                }
                if (!f.exists()) {
                    this.error(Messages.Phing_NotAPHPCommand(f));
                    return;
                }
                this.ok();
            }
        }.process();
    }
}

