/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.phing;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.phing.Messages;
import hudson.plugins.phing.PhingDescriptor;
import hudson.plugins.phing.PhingInstallation;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PhingBuilder
extends Builder {
    public static final PhingDescriptor DESCRIPTOR = new PhingDescriptor();
    private static final boolean DEBUG = false;
    private final String buildFile;
    private final String name;
    private final String targets;
    private final String properties;

    public String getBuildFile() {
        return this.buildFile;
    }

    public String getName() {
        return this.name;
    }

    public String getTargets() {
        return this.targets;
    }

    public String getProperties() {
        return this.properties;
    }

    @DataBoundConstructor
    public PhingBuilder(String name, String buildFile, String targets, String properties) {
        this.name = Util.fixEmptyAndTrim((String)name);
        this.buildFile = Util.fixEmptyAndTrim((String)buildFile);
        this.targets = Util.fixEmptyAndTrim((String)targets);
        this.properties = Util.fixEmptyAndTrim((String)properties);
    }

    public PhingInstallation getPhing() {
        for (PhingInstallation inst : DESCRIPTOR.getInstallations()) {
            if (this.name == null || !this.name.equals(inst.getName())) continue;
            return inst;
        }
        return null;
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath buildFilePath;
        String phpCommand;
        ArgumentListBuilder args = new ArgumentListBuilder();
        EnvVars env = build.getEnvironment((TaskListener)listener);
        PhingInstallation pi = this.getPhing();
        if (pi != null && (phpCommand = pi.getPhpCommand()) != null) {
            env.put((Object)"PHP_COMMAND", (Object)phpCommand);
        }
        if (pi == null) {
            args.add(PhingInstallation.getExecName((Launcher)launcher));
        } else {
            args.add(pi.getExecutable(launcher));
        }
        if (this.buildFile == null) {
            buildFilePath = build.getModuleRoot().child("build.xml");
        } else {
            boolean absolute = new File(this.buildFile).isAbsolute();
            buildFilePath = absolute ? new FilePath(new File(this.buildFile)) : build.getModuleRoot().child(this.buildFile);
            args.add(new String[]{"-buildfile", buildFilePath.getName()});
        }
        if (this.targets != null) {
            String normalizedTargets = this.targets.replaceAll("[\t\r\n]+", " ");
            args.addTokenized(normalizedTargets);
        }
        if (this.properties != null) {
            Properties props = this.loadProperties();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                args.add("-D" + entry.getKey() + "=" + entry.getValue());
            }
        }
        args.addKeyValuePairs("-D", build.getBuildVariables());
        args.add(new String[]{"-logger", "phing.listener.NoBannerLogger"});
        if (pi != null && pi.getPhingHome() != null) {
            env.put((Object)"PHING_HOME", (Object)pi.getPhingHome());
            env.put((Object)"PHING_CLASSPATH", (Object)(pi.getPhingHome() + File.separator + "classes"));
        }
        if (!launcher.isUnix()) {
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
            args = new ArgumentListBuilder().add(new String[]{"cmd.exe", "/C"}).addQuoted(args.toStringWithQuote());
        }
        long startTime = System.currentTimeMillis();
        try {
            int result = launcher.launch().cmds(args).envs((Map)env).stdout((TaskListener)listener).pwd(buildFilePath.getParent()).join();
            return result == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            long processingTime = System.currentTimeMillis() - startTime;
            String errorMessage = this.buildErrorMessage(pi, processingTime);
            e.printStackTrace(listener.fatalError(errorMessage));
            return false;
        }
    }

    private String buildErrorMessage(PhingInstallation pi, long processingTime) {
        StringBuffer msg = new StringBuffer();
        msg.append(Messages.Phing_ExecFailed());
        if (pi == null && processingTime < 1000L) {
            if (DESCRIPTOR.getInstallations() == null) {
                msg.append(Messages.Phing_GlocalConfigNeeded());
            } else {
                msg.append(Messages.Phing_ProjectConfigNeeded());
            }
        }
        return msg.toString();
    }

    private Properties loadProperties() throws IOException {
        Properties props = new Properties();
        try {
            props.load(new StringReader(this.properties));
        }
        catch (NoSuchMethodError e) {
            props.load(new ByteArrayInputStream(this.properties.getBytes()));
        }
        return props;
    }
}

