/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.phing.console;

import hudson.console.LineTransformationOutputStream;
import hudson.plugins.phing.console.PhingOutcomeNote;
import hudson.plugins.phing.console.PhingPHPErrorNote;
import hudson.plugins.phing.console.PhingTargetNote;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class PhingConsoleAnnotator
extends LineTransformationOutputStream {
    private final OutputStream out;
    private final Charset charset;
    private boolean seenEmptyLine;

    public PhingConsoleAnnotator(OutputStream out, Charset charset) {
        this.out = out;
        this.charset = charset;
    }

    protected void eol(byte[] b, int len) throws IOException {
        String line = this.charset.decode(ByteBuffer.wrap(b, 0, len)).toString();
        line = this.trimEOL(line);
        if (this.seenEmptyLine && line.endsWith(":") && line.indexOf(62) > 0) {
            new PhingTargetNote().encodeTo(this.out);
        }
        if (line.startsWith("Fatal error: ") || line.startsWith("Warning error: ") || line.startsWith("Parse error: ") || line.startsWith("Notice: ")) {
            new PhingPHPErrorNote().encodeTo(this.out);
        }
        if (this.seenEmptyLine && (line.startsWith("BUILD FINISHED") || line.startsWith("BUILD FAILED"))) {
            new PhingOutcomeNote().encodeTo(this.out);
        }
        this.seenEmptyLine = line.length() == 0;
        this.out.write(b, 0, len);
    }

    public void close() throws IOException {
        super.close();
        this.out.close();
    }
}

