/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.phing;

import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.phing.Messages;
import hudson.plugins.phing.PhingBuilder;
import hudson.plugins.phing.PhingInstallation;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PhingDescriptor
extends Descriptor<Builder> {
    private volatile PhingInstallation[] installations = new PhingInstallation[0];

    public PhingDescriptor() {
        super(PhingBuilder.class);
        this.load();
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        List list = req.bindJSONToList(PhingInstallation.class, formData.get("phing"));
        this.installations = list.toArray(new PhingInstallation[list.size()]);
        this.save();
        return true;
    }

    public String getHelpFile() {
        return "/plugin/phing/help.html";
    }

    public String getDisplayName() {
        return Messages.Phing_DisplayName();
    }

    public PhingInstallation[] getInstallations() {
        return Arrays.copyOf(this.installations, this.installations.length);
    }

    public PhingBuilder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        return (PhingBuilder)((Object)req.bindJSON(PhingBuilder.class, formData));
    }

    public FormValidation doCheckPhingHome(@QueryParameter File value) {
        if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
            return FormValidation.ok();
        }
        if ("".equals(value.getPath().trim())) {
            return FormValidation.error((String)Messages.Phing_PhingHomeRequired());
        }
        if (!value.isDirectory()) {
            return FormValidation.error((String)Messages.Phing_NotAPHPCommand(value));
        }
        File phing = new File(value, "bin" + File.separator + "phing.php");
        if (!phing.exists()) {
            return FormValidation.error((String)Messages.Phing_NotAPhingDirectory(value));
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckPhpCommand(@QueryParameter File value) {
        if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
            return FormValidation.ok();
        }
        if ("".equals(value.getPath().trim())) {
            return FormValidation.ok();
        }
        if (!value.exists()) {
            return FormValidation.error((String)Messages.Phing_NotAPHPCommand(value));
        }
        if (value.isDirectory()) {
            return FormValidation.error((String)Messages.Phing_DirectoryNotAllowed(value));
        }
        return FormValidation.ok();
    }
}

