/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.platformlabeler;

import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.slaves.ComputerListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hudson.plugins.platformlabeler.PlatformDetailsTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeLabelCache
extends ComputerListener {
    static transient WeakHashMap<Node, Set<Label>> nodeLabels = new WeakHashMap();
    private final transient Logger logger = Logger.getLogger("org.jvnet.hudson.plugins.platformlabeler");

    public void onOnline(Computer computer, TaskListener listener) throws IOException, InterruptedException {
        this.cacheLabels(computer);
        this.refreshModel(computer);
    }

    void cacheLabels(Computer computer) throws IOException, InterruptedException {
        nodeLabels.put(computer.getNode(), this.requestNodeLabels(computer));
    }

    void refreshModel(Computer computer) {
        computer.getNode().getAssignedLabels();
    }

    private Set<Label> requestNodeLabels(Computer computer) throws IOException, InterruptedException {
        VirtualChannel channel = computer.getChannel();
        if (null == channel) {
            throw new IOException("No virtual channel available");
        }
        HashSet<Label> result = new HashSet<Label>();
        Hudson hudson = Hudson.getInstance();
        try {
            Set labels = (Set)channel.call((Callable)new PlatformDetailsTask());
            for (String label : labels) {
                result.add(hudson.getLabel(label));
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Failed to read labels", e);
            throw e;
        }
        return result;
    }
}

