/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.platformlabeler;

import hudson.remoting.Callable;
import java.io.IOException;
import java.util.HashSet;
import net.robertcollins.lsb.Release;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlatformDetailsTask
implements Callable<HashSet<String>, IOException> {
    PlatformDetailsTask() {
    }

    public HashSet<String> call() throws IOException {
        String arch = System.getProperty("os.arch");
        String name = System.getProperty("os.name").toLowerCase();
        String version = System.getProperty("os.version");
        if (name.equals("solaris") || name.equals("SunOS")) {
            name = "solaris";
        } else if (name.startsWith("windows")) {
            name = "windows";
            if (name.startsWith("windows 9")) {
                if (version.startsWith("4.0")) {
                    version = "95";
                } else if (version.startsWith("4.9")) {
                    version = "me";
                } else {
                    assert (version.startsWith("4.1"));
                    version = "98";
                }
            } else if (version.startsWith("4.0")) {
                version = "nt4";
            } else if (version.startsWith("5.0")) {
                version = "2000";
            } else if (version.startsWith("5.1")) {
                version = "xp";
            } else if (version.startsWith("5.2")) {
                version = "2003";
            }
        } else if (name.startsWith("linux")) {
            String unknown_string = "unknown+check_lsb_release_installed";
            Release release = new Release();
            name = release.distributorId();
            if (null == name) {
                name = unknown_string;
            }
            if (null == (version = release.release())) {
                version = unknown_string;
            }
        } else if (name.startsWith("mac")) {
            name = "mac";
        }
        HashSet<String> result = new HashSet<String>();
        result.add(arch);
        result.add(name);
        result.add(version);
        result.add(arch + "-" + name);
        result.add(name + "-" + version);
        result.add(arch + "-" + name + "-" + version);
        return result;
    }
}

