/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ikeike443;

import com.gmail.ikeike443.PlayAutoTestBuilder;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.tasks.Builder;
import java.io.File;
import java.io.OutputStream;
import org.kohsuke.stapler.DataBoundConstructor;

public class PlayAutoTestBuilder
extends Builder {
    private final String play_cmd;

    @DataBoundConstructor
    public PlayAutoTestBuilder(String play_cmd) {
        this.play_cmd = play_cmd;
    }

    public String getPlay_cmd() {
        return this.play_cmd;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        String playpath = null;
        if (this.getDescriptor().path() == null) {
            listener.getLogger().println("play path is null");
            return false;
        }
        playpath = this.getDescriptor().path();
        listener.getLogger().println("playpath is " + playpath);
        try {
            String cmd = playpath + " " + this.play_cmd + " " + build.getWorkspace().toString();
            listener.getLogger().println(cmd);
            Proc proc = launcher.launch(cmd, new String[0], (OutputStream)listener.getLogger(), build.getWorkspace());
            int exitcode = proc.join();
            if (exitcode == 0) {
                return new File(build.getWorkspace().toString() + "/test-result/result.passed").exists();
            }
            listener.getLogger().println("play test failed");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }
}

