/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ikeike443;

import hudson.Extension;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class PlayAutoTestBuilder
extends Builder {
    private final String play_cmd;

    @DataBoundConstructor
    public PlayAutoTestBuilder(String play_cmd) {
        this.play_cmd = play_cmd;
    }

    public String getPlay_cmd() {
        return this.play_cmd;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        String playpath = null;
        if (this.getDescriptor().path() == null) {
            listener.getLogger().println("play path is null");
            return false;
        }
        playpath = this.getDescriptor().path();
        listener.getLogger().println("playpath is " + playpath);
        try {
            String cmd = playpath + " " + this.play_cmd + " " + build.getWorkspace().toString();
            listener.getLogger().println(cmd);
            Proc proc = launcher.launch(cmd, new String[0], (OutputStream)listener.getLogger(), build.getWorkspace());
            int exitcode = proc.join();
            if (exitcode == 0) {
                return new File(build.getWorkspace().toString() + "/test-result/result.passed").exists();
            }
            listener.getLogger().println("play test failed");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String path;

        public FormValidation doCheckName(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set path to play");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Play!";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.path = formData.getString("play_path");
            this.save();
            return super.configure(req, formData);
        }

        public String path() {
            return this.path;
        }
    }
}

