/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.ikeike443;

import com.gmail.ikeike443.PlayTestResultAction;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.kohsuke.stapler.DataBoundConstructor;

public class PlayTestResultPublisher
extends Publisher {
    @DataBoundConstructor
    public PlayTestResultPublisher() {
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        try {
            FilePath[] files = build.getProject().getWorkspace().list("test-result/*");
            FilePath root = new FilePath(build.getRootDir());
            for (FilePath filePath : files) {
                filePath.copyTo(new FilePath(root, "test-result/" + filePath.getName()));
            }
            Properties conf = new Properties();
            FileInputStream inputStream = new FileInputStream(new File(build.getWorkspace() + "/conf/application.conf"));
            conf.load(inputStream);
            PlayTestResultAction act = new PlayTestResultAction(build);
            act.setPassed(new FilePath(root, "test-result/result.passed").exists());
            act.setAppName(conf.getProperty("application.name"));
            build.addAction((Action)act);
            ((InputStream)inputStream).close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Play! auto-test reports";
        }
    }
}

