/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.plugins.plot.Plot;
import hudson.plugins.plot.PlotAction;
import hudson.plugins.plot.Series;
import hudson.tasks.Publisher;
import hudson.util.FormFieldValidator;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotPublisher
extends Publisher {
    private static final Logger LOGGER = Logger.getLogger(PlotPublisher.class.getName());
    private ArrayList<Plot> plots = new ArrayList();
    private transient HashMap<String, ArrayList<Plot>> groupMap = new HashMap();
    public static final Descriptor<Publisher> DESCRIPTOR = new DescriptorImpl();

    private Object readResolve() {
        Plot[] p = this.plots.toArray(new Plot[0]);
        this.setPlots(p);
        return this;
    }

    public String urlGroupToOriginalGroup(String urlGroup) {
        ArrayList<Plot> plots;
        if (urlGroup == null || "nogroup".equals(urlGroup)) {
            return "Plots";
        }
        if (this.groupMap.containsKey(urlGroup) && (plots = this.groupMap.get(urlGroup)).size() > 0) {
            return plots.get((int)0).group;
        }
        return "";
    }

    public String originalGroupToUrlGroup(String originalGroup) {
        if (originalGroup == null || "".equals(originalGroup)) {
            return "nogroup";
        }
        try {
            return URLEncoder.encode(originalGroup.replace('/', ' '), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return originalGroup;
        }
    }

    public String[] getOriginalGroups() {
        ArrayList<String> originalGroups = new ArrayList<String>();
        for (String urlGroup : this.groupMap.keySet()) {
            originalGroups.add(this.urlGroupToOriginalGroup(urlGroup));
        }
        Object[] retVal = originalGroups.toArray(new String[0]);
        Arrays.sort(retVal);
        return retVal;
    }

    public void setPlots(Plot[] plots) {
        this.plots = new ArrayList();
        this.groupMap = new HashMap();
        for (Plot plot : plots) {
            this.addPlot(plot);
        }
    }

    public void addPlot(Plot plot) {
        this.plots.add(plot);
        String urlGroup = this.originalGroupToUrlGroup(plot.getGroup());
        if (this.groupMap.containsKey(urlGroup)) {
            ArrayList<Plot> list = this.groupMap.get(urlGroup);
            list.add(plot);
        } else {
            ArrayList<Plot> list = new ArrayList<Plot>();
            list.add(plot);
            this.groupMap.put(urlGroup, list);
        }
    }

    public Plot[] getPlots() {
        return this.plots.toArray(new Plot[0]);
    }

    public Plot[] getPlots(String urlGroup) {
        ArrayList<Plot> p = this.groupMap.get(urlGroup);
        if (p != null) {
            return p.toArray(new Plot[0]);
        }
        return new Plot[0];
    }

    public Action getProjectAction(Project project) {
        return new PlotAction(project, this);
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean perform(Build build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        listener.getLogger().println("Recording plot data");
        for (Plot plot : this.getPlots()) {
            plot.addBuild(build, listener.getLogger());
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<Publisher> {
        public DescriptorImpl() {
            super(PlotPublisher.class);
        }

        public String getDisplayName() {
            return "Plot build data";
        }

        public String getHelpFile() {
            return "/publisher/PlotPublisher/help";
        }

        public Publisher newInstance(StaplerRequest req) throws Descriptor.FormException {
            Random r = new Random();
            PlotPublisher publisher = new PlotPublisher();
            String[] fileNames = req.getParameterValues("plotParam.csvFileName");
            String[] titles = req.getParameterValues("plotParam.title");
            String[] yaxises = req.getParameterValues("plotParam.yaxis");
            String[] groups = req.getParameterValues("plotParam.group");
            String[] numBuilds = req.getParameterValues("plotParam.numBuilds");
            String[] seriesFiles = req.getParameterValues("seriesParam.file");
            String[] seriesLabels = req.getParameterValues("seriesParam.label");
            if (seriesFiles != null) {
                int len = fileNames.length;
                int seriesCounter = 0;
                for (int i = 0; i < len; ++i) {
                    String builds;
                    ArrayList<Series> seriesList = new ArrayList<Series>();
                    while (seriesCounter < seriesFiles.length && !seriesFiles[seriesCounter].equals("PLOT_SEPARATOR")) {
                        seriesList.add(new Series(seriesFiles[seriesCounter], seriesLabels[seriesCounter]));
                        ++seriesCounter;
                    }
                    ++seriesCounter;
                    if (fileNames[i] == null || fileNames[i].trim().equals("")) {
                        fileNames[i] = Math.abs(r.nextInt()) + ".csv";
                    }
                    try {
                        builds = Integer.parseInt(numBuilds[i]) + "";
                    }
                    catch (NumberFormatException nfe) {
                        builds = "";
                    }
                    Plot plot = new Plot(titles[i], yaxises[i], seriesList.toArray(new Series[0]), groups[i], builds, fileNames[i]);
                    publisher.addPlot(plot);
                }
            }
            return publisher;
        }

        public void doCheckSeriesFile(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                public void check() throws IOException, ServletException {
                    String file = this.request.getParameter("value");
                    if (file == null || "".equals(file)) {
                        this.error("File must be specified");
                        return;
                    }
                }
            }.process();
            new FormFieldValidator.WorkspaceFileMask(req, rsp).process();
        }

        public void doCheckNumBuilds(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                public void check() throws IOException, ServletException {
                    try {
                        String numBuilds = this.request.getParameter("value");
                        if ("".equals(numBuilds)) {
                            this.ok();
                        } else {
                            int num = Integer.parseInt(numBuilds);
                            if (num == 0) {
                                this.error("Must be greater than 0");
                            } else {
                                this.ok();
                            }
                        }
                    }
                    catch (NumberFormatException nfe) {
                        this.error("Not a valid integer number");
                    }
                }
            }.process();
        }
    }
}

