/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.plugins.plot.Plot;
import hudson.plugins.plot.PlotAction;
import hudson.plugins.plot.PlotPublisher;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotPublisher
extends Publisher {
    private static final Logger LOGGER = Logger.getLogger(PlotPublisher.class.getName());
    private ArrayList<Plot> plots = new ArrayList();
    private transient HashMap<String, ArrayList<Plot>> groupMap = new HashMap();
    public static final Descriptor<Publisher> DESCRIPTOR = new DescriptorImpl();

    private Object readResolve() {
        Plot[] p = this.plots.toArray(new Plot[0]);
        this.setPlots(p);
        return this;
    }

    public String urlGroupToOriginalGroup(String urlGroup) {
        ArrayList plots;
        if (urlGroup == null || "nogroup".equals(urlGroup)) {
            return "Plots";
        }
        if (this.groupMap.containsKey(urlGroup) && (plots = (ArrayList)this.groupMap.get(urlGroup)).size() > 0) {
            return ((Plot)plots.get((int)0)).group;
        }
        return "";
    }

    public String originalGroupToUrlGroup(String originalGroup) {
        if (originalGroup == null || "".equals(originalGroup)) {
            return "nogroup";
        }
        try {
            return URLEncoder.encode(originalGroup.replace('/', ' '), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return originalGroup;
        }
    }

    public String[] getOriginalGroups() {
        ArrayList<String> originalGroups = new ArrayList<String>();
        for (String urlGroup : this.groupMap.keySet()) {
            originalGroups.add(this.urlGroupToOriginalGroup(urlGroup));
        }
        Object[] retVal = originalGroups.toArray(new String[0]);
        Arrays.sort(retVal);
        return retVal;
    }

    public void setPlots(Plot[] plots) {
        this.plots = new ArrayList();
        this.groupMap = new HashMap();
        for (Plot plot : plots) {
            this.addPlot(plot);
        }
    }

    public void addPlot(Plot plot) {
        this.plots.add(plot);
        String urlGroup = this.originalGroupToUrlGroup(plot.getGroup());
        if (this.groupMap.containsKey(urlGroup)) {
            ArrayList list = (ArrayList)this.groupMap.get(urlGroup);
            list.add(plot);
        } else {
            ArrayList<Plot> list = new ArrayList<Plot>();
            list.add(plot);
            this.groupMap.put(urlGroup, list);
        }
    }

    public Plot[] getPlots() {
        return this.plots.toArray(new Plot[0]);
    }

    public Plot[] getPlots(String urlGroup) {
        ArrayList p = (ArrayList)this.groupMap.get(urlGroup);
        if (p != null) {
            return p.toArray(new Plot[0]);
        }
        return new Plot[0];
    }

    public Action getProjectAction(Project project) {
        return new PlotAction(project, this);
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean perform(Build build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        listener.getLogger().println("Recording plot data");
        for (Plot plot : this.getPlots()) {
            plot.addBuild(build, listener.getLogger());
        }
        return true;
    }
}

