/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import hudson.model.Project;
import hudson.plugins.plot.Plot;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class PlotReport {
    private static final Logger LOGGER = Logger.getLogger(PlotReport.class.getName());
    private final Project project;
    private Plot[] plots;
    private String group;

    public PlotReport(Project project, String group, Plot[] plots) {
        Arrays.sort(plots);
        this.plots = plots;
        this.group = group;
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public String getGroup() {
        return this.group;
    }

    public Plot[] getPlots() {
        return this.plots;
    }

    public void doGetPlot(StaplerRequest req, StaplerResponse rsp) {
        String i = req.getParameter("index");
        Plot plot = this.getPlot(i);
        try {
            plot.plotGraph(req, rsp);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.INFO, "Exception plotting graph", ioe);
        }
    }

    public void doGetPlotMap(StaplerRequest req, StaplerResponse rsp) {
        String i = req.getParameter("index");
        Plot plot = this.getPlot(i);
        try {
            plot.plotGraphMap(req, rsp);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.INFO, "Exception plotting graph", ioe);
        }
    }

    private Plot getPlot(String i) {
        try {
            Plot p = this.plots[Integer.valueOf(i)];
            p.setProject(this.project);
            return p;
        }
        catch (NumberFormatException ignore) {
            return null;
        }
    }
}

