/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.model.Build;
import hudson.model.Project;
import hudson.model.Run;
import hudson.plugins.plot.PlotCategoryDataset;
import hudson.plugins.plot.PointURLGenerator;
import hudson.plugins.plot.Series;
import hudson.util.ChartUtil;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class Plot
implements Comparable {
    private static final transient Logger LOGGER = Logger.getLogger(Plot.class.getName());
    private static final transient SimpleDateFormat dateFormat = new SimpleDateFormat("MMM d");
    private transient ArrayList<String[]> rawPlotData;
    private transient JFreeChart plot;
    private transient AbstractProject project;
    private static final transient DrawingSupplier supplier = new DefaultDrawingSupplier(DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, new Shape[]{new Polygon(new int[]{3, 0, -3, 0}, new int[]{0, 4, 0, -4}, 4)});
    private static final transient int DEFAULT_WIDTH = 750;
    private static final transient int DEFAULT_HEIGHT = 450;
    private static final transient String DEFAULT_NUMBUILDS = "";
    private transient int width;
    private transient int height;
    private transient int rightBuildNum;
    private transient boolean hasLegend = true;
    public transient String urlNumBuilds = null;
    public transient String urlTitle = null;
    public String title;
    public String yaxis;
    public Series[] series;
    public String group;
    public String numBuilds;
    public String csvFileName;
    private long csvLastModification;

    public Plot(String title, String yaxis, Series[] series, String group, String numBuilds, String csvFileName) {
        this.title = title;
        this.yaxis = yaxis;
        this.series = series;
        this.group = group;
        this.numBuilds = numBuilds;
        this.csvFileName = csvFileName;
    }

    public Plot() {
    }

    public int compareTo(Object o) {
        return this.title.compareTo(((Plot)o).getTitle());
    }

    public String toString() {
        return "TITLE(" + this.getTitle() + "),YAXIS(" + this.yaxis + "),NUMSERIES(" + this.series.length + "),GROUP(" + this.group + "),NUMBUILDS(" + this.getNumBuilds() + "),RIGHTBUILDNUM(" + this.getRightBuildNum() + "),HASLEGEND(" + this.hasLegend() + "),FILENAME(" + this.csvFileName + ")";
    }

    public String getYaxis() {
        return this.yaxis;
    }

    public Series[] getSeries() {
        return this.series;
    }

    public String getGroup() {
        return this.group;
    }

    public String getCsvFileName() {
        return this.csvFileName;
    }

    private void setTitle(StaplerRequest req) {
        this.urlTitle = req.getParameter("title");
    }

    public String getURLTitle() {
        if (this.urlTitle != null) {
            return this.urlTitle;
        }
        return this.title;
    }

    public String getTitle() {
        return this.title;
    }

    private void setHasLegend(StaplerRequest req) {
        String legend = req.getParameter("legend");
        if (legend == null) {
            this.hasLegend = true;
        } else {
            try {
                this.hasLegend = Boolean.parseBoolean(legend);
            }
            catch (NumberFormatException nfe) {
                this.hasLegend = true;
            }
        }
    }

    public boolean hasLegend() {
        return this.hasLegend;
    }

    private void setNumBuilds(StaplerRequest req) {
        this.urlNumBuilds = req.getParameter("numbuilds");
        if (this.urlNumBuilds != null) {
            try {
                int tmp = Integer.parseInt(this.urlNumBuilds);
            }
            catch (NumberFormatException nfe) {
                this.urlNumBuilds = null;
            }
        }
    }

    public String getURLNumBuilds() {
        if (this.urlNumBuilds != null) {
            return this.urlNumBuilds;
        }
        return this.numBuilds;
    }

    public String getNumBuilds() {
        return this.numBuilds;
    }

    private void setRightBuildNum(StaplerRequest req) {
        String build = req.getParameter("rightbuildnum");
        if (build == null) {
            this.rightBuildNum = Integer.MAX_VALUE;
        } else {
            try {
                this.rightBuildNum = Integer.parseInt(build);
            }
            catch (NumberFormatException nfe) {
                this.rightBuildNum = Integer.MAX_VALUE;
            }
        }
    }

    private int getRightBuildNum() {
        return this.rightBuildNum;
    }

    private void setWidth(StaplerRequest req) {
        String w = req.getParameter("width");
        if (w == null) {
            this.width = 750;
        } else {
            try {
                this.width = Integer.parseInt(w);
            }
            catch (NumberFormatException nfe) {
                this.width = 750;
            }
        }
    }

    private int getWidth() {
        return this.width;
    }

    private int getHeight() {
        return this.height;
    }

    private void setHeight(StaplerRequest req) {
        String h = req.getParameter("height");
        if (h == null) {
            this.height = 450;
        } else {
            try {
                this.height = Integer.parseInt(h);
            }
            catch (NumberFormatException nfe) {
                this.height = 450;
            }
        }
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void plotGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblem) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        this.setWidth(req);
        this.setHeight(req);
        this.setNumBuilds(req);
        this.setRightBuildNum(req);
        this.setHasLegend(req);
        this.setTitle(req);
        this.generatePlot(true);
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)this.plot, (int)this.getWidth(), (int)this.getHeight());
    }

    public void plotGraphMap(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblem) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        this.setWidth(req);
        this.setHeight(req);
        this.setNumBuilds(req);
        this.setRightBuildNum(req);
        this.setHasLegend(req);
        this.setTitle(req);
        this.generatePlot(false);
        ChartRenderingInfo info = new ChartRenderingInfo();
        this.plot.createBufferedImage(this.getWidth(), this.getHeight(), info);
        rsp.setContentType("text/plain;charset=UTF-8");
        rsp.getWriter().println(ChartUtilities.getImageMap((String)this.getCsvFileName(), (ChartRenderingInfo)info));
    }

    public void addBuild(Build build, PrintStream logger) {
        if (this.project == null) {
            this.project = build.getProject();
        }
        this.loadPlotData();
        for (Series series : this.getSeries()) {
            Properties seriesData = this.loadSeriesData(series, this.project.getWorkspace(), logger);
            if (seriesData == null) continue;
            this.rawPlotData.add(new String[]{seriesData.getProperty("YVALUE"), series.getLabel(), build.getNumber() + DEFAULT_NUMBUILDS, build.getTimestamp().getTimeInMillis() + DEFAULT_NUMBUILDS, seriesData.getProperty("URL")});
        }
        this.savePlotData();
    }

    private void generatePlot(boolean forceGenerate) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Label
        implements Comparable<Label> {
            private Integer buildNum;
            private String buildDate;

            public Label(String buildNum, String buildTime) {
                this.buildNum = Integer.parseInt(buildNum);
                this.buildDate = dateFormat.format(new Date(Long.parseLong(buildTime)));
            }

            @Override
            public int compareTo(Label that) {
                return this.buildNum - that.buildNum;
            }

            public boolean equals(Object o) {
                Label that = (Label)o;
                return this.buildNum.equals(that.buildNum);
            }

            public int hashCode() {
                return this.buildNum.hashCode();
            }

            public String toString() {
                return "#" + this.buildNum + " (" + this.buildDate + ")";
            }
        }
        int numBuilds;
        File csvFile = new File(this.project.getRootDir(), this.getCsvFileName());
        if (csvFile.lastModified() == this.csvLastModification && this.plot != null && !forceGenerate) {
            return;
        }
        if (this.rawPlotData == null || csvFile.lastModified() > this.csvLastModification) {
            this.loadPlotData();
        }
        this.csvLastModification = csvFile.lastModified();
        PlotCategoryDataset dataset = new PlotCategoryDataset();
        for (String[] record : this.rawPlotData) {
            try {
                int buildNum = Integer.valueOf(record[2]);
                if (buildNum > this.getRightBuildNum()) {
                }
            }
            catch (NumberFormatException nfe) {}
            continue;
            Number value = null;
            try {
                value = Integer.valueOf(record[0]);
            }
            catch (NumberFormatException nfe) {
                try {
                    value = Double.valueOf(record[0]);
                }
                catch (NumberFormatException nfe2) {
                    continue;
                }
            }
            String series = record[1];
            Label xlabel = new Label(record[2], record[3]);
            String url = null;
            if (record.length >= 5) {
                url = record[4];
            }
            dataset.setValue(value, url, (Comparable)((Object)series), xlabel);
        }
        try {
            numBuilds = Integer.parseInt(this.getURLNumBuilds());
        }
        catch (NumberFormatException nfe) {
            numBuilds = Integer.MAX_VALUE;
        }
        dataset.clipDataset(numBuilds);
        this.plot = ChartFactory.createLineChart((String)this.getURLTitle(), null, (String)this.getYaxis(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.hasLegend(), (boolean)true, (boolean)false);
        CategoryPlot categoryPlot = (CategoryPlot)this.plot.getPlot();
        categoryPlot.setDomainGridlinePaint((Paint)Color.black);
        categoryPlot.setRangeGridlinePaint((Paint)Color.black);
        categoryPlot.setDrawingSupplier(supplier);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis("Build");
        categoryPlot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.03);
        domainAxis.setCategoryMargin(0.0);
        for (Object category : dataset.getColumnKeys()) {
            Run r = this.project.getBuildByNumber(((Label)category).buildNum.intValue());
            String tip = null;
            if (r != null && (tip = r.getTruncatedDescription()) != null) {
                tip = tip.replaceAll("<p> *|<br> *", ", ");
            }
            domainAxis.addCategoryLabelToolTip((Comparable)category, tip);
        }
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        Color[] LINE_GRAPH = new Color[]{new Color(0xCC0000), new Color(3433892), new Color(7590422), new Color(15586304), new Color(9055202), new Color(13789470), new Color(0xEE82EE), new Color(0)};
        int n = 0;
        for (Color c : LINE_GRAPH) {
            renderer.setSeriesPaint(n++, (Paint)c);
        }
        renderer.setShapesVisible(true);
        renderer.setStroke((Stroke)new BasicStroke(2.0f));
        renderer.setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator("Build {1}: {2}", NumberFormat.getInstance()));
        renderer.setItemURLGenerator((CategoryURLGenerator)new PointURLGenerator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPlotData() {
        this.rawPlotData = new ArrayList();
        File plotFile = new File(this.project.getRootDir(), this.getCsvFileName());
        if (!plotFile.exists()) {
            return;
        }
        CSVReader reader = null;
        this.rawPlotData = new ArrayList();
        try {
            String[] nextLine;
            reader = new CSVReader((Reader)new FileReader(plotFile));
            reader.readNext();
            reader.readNext();
            while ((nextLine = reader.readNext()) != null) {
                this.rawPlotData.add(nextLine);
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePlotData() {
        File plotFile = new File(this.project.getRootDir(), this.getCsvFileName());
        CSVWriter writer = null;
        try {
            writer = new CSVWriter((Writer)new FileWriter(plotFile));
            String[] header1 = new String[]{"Title", this.getTitle()};
            String[] header2 = new String[]{"Value", "Series Label", "Build Number", "Build Date", "URL"};
            writer.writeNext(header1);
            writer.writeNext(header2);
            for (String[] entry : this.rawPlotData) {
                writer.writeNext(entry);
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadSeriesData(Series series, FilePath workspaceRootDir, PrintStream logger) {
        InputStream in = null;
        FilePath[] seriesFiles = null;
        try {
            seriesFiles = workspaceRootDir.list(series.getFile());
        }
        catch (Exception e) {
            logger.println("Exception trying to retrieve series files: " + e);
            return null;
        }
        if (seriesFiles != null && seriesFiles.length < 1) {
            logger.println("No plot data file found: " + series.getFile());
            return null;
        }
        try {
            in = seriesFiles[0].read();
            logger.println("Saving plot series data from: " + seriesFiles[0]);
            Properties data = new Properties();
            data.load(in);
            Properties properties = data;
            return properties;
        }
        catch (Exception e) {
            logger.println("Exception reading plot series data from: " + seriesFiles[0]);
            Properties properties = null;
            return properties;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
    }
}

