/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import au.com.bytecode.opencsv.CSVReader;
import hudson.FilePath;
import hudson.plugins.plot.CSVSeries;
import hudson.plugins.plot.PlotPoint;
import hudson.plugins.plot.Series;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * Exception performing whole class analysis ignored.
 */
public class CSVSeries
extends Series {
    private static final transient Logger LOGGER = Logger.getLogger(Series.class.getName());
    private static final transient Level defaultLogLevel = Level.FINEST;
    private static final transient Pattern PAT_COMMA = Pattern.compile(",");
    private static final transient Pattern PAT_NAME = Pattern.compile("%name%");
    private static final transient Pattern PAT_INDEX = Pattern.compile("%index%");
    private Set<String> strExclusionSet;
    private Set<Integer> colExclusionSet;
    private InclusionFlag inclusionFlag = InclusionFlag.OFF;
    private String exclusionValues;
    private String url;
    private boolean displayTableFlag;

    @DataBoundConstructor
    public CSVSeries(String file, String url, String inclusionFlag, String exclusionValues, boolean displayTableFlag) {
        super(file, "", "csv");
        this.url = url;
        if (exclusionValues == null) {
            this.inclusionFlag = InclusionFlag.OFF;
            return;
        }
        this.inclusionFlag = InclusionFlag.valueOf((String)inclusionFlag);
        this.exclusionValues = exclusionValues;
        this.displayTableFlag = displayTableFlag;
        this.loadExclusionSet();
    }

    public String getInclusionFlag() {
        return this.inclusionFlag.toString();
    }

    public String getExclusionValues() {
        return this.exclusionValues;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean getDisplayTableFlag() {
        return this.displayTableFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlotPoint[] loadSeries(FilePath workspaceRootDir, PrintStream logger) {
        block67: {
            PlotPoint[] plotPointArray;
            CSVReader reader = null;
            InputStream in = null;
            InputStreamReader inputReader = null;
            try {
                String[] nextLine;
                ArrayList<PlotPoint> ret = new ArrayList<PlotPoint>();
                FilePath[] seriesFiles = null;
                try {
                    seriesFiles = workspaceRootDir.list(this.getFile());
                }
                catch (Exception e) {
                    LOGGER.warning("Exception trying to retrieve series files: " + e);
                    PlotPoint[] plotPointArray2 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ignore) {
                            // empty catch block
                        }
                    }
                    if (inputReader != null) {
                        try {
                            inputReader.close();
                        }
                        catch (IOException ignore) {
                            // empty catch block
                        }
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ignore) {
                            // empty catch block
                        }
                    }
                    return plotPointArray2;
                }
                if (seriesFiles != null && seriesFiles.length < 1) {
                    LOGGER.info("No plot data file found: " + workspaceRootDir.getName() + " " + this.getFile());
                    PlotPoint[] e = null;
                    return e;
                }
                try {
                    if (LOGGER.isLoggable(defaultLogLevel)) {
                        LOGGER.log(defaultLogLevel, "Loading plot series data from: " + this.getFile());
                    }
                    in = seriesFiles[0].read();
                }
                catch (Exception e) {
                    LOGGER.warning("Exception reading plot series data from: " + seriesFiles[0] + " " + e);
                    PlotPoint[] ignore = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ignore2) {
                            // empty catch block
                        }
                    }
                    if (inputReader != null) {
                        try {
                            inputReader.close();
                        }
                        catch (IOException ignore3) {
                            // empty catch block
                        }
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ignore4) {
                            // empty catch block
                        }
                    }
                    return ignore;
                }
                if (LOGGER.isLoggable(defaultLogLevel)) {
                    LOGGER.log(defaultLogLevel, "Loaded CSV Plot file: " + this.getFile());
                }
                inputReader = new InputStreamReader(in);
                reader = new CSVReader((Reader)inputReader);
                String[] headerLine = reader.readNext();
                int lineNum = 0;
                while ((nextLine = reader.readNext()) != null) {
                    if (nextLine.length == 1 && nextLine[0].length() == 0) continue;
                    for (int index = 0; index < nextLine.length; ++index) {
                        String label = null;
                        if (index > nextLine.length) continue;
                        String yvalue = nextLine[index];
                        if (index < headerLine.length) {
                            label = headerLine[index];
                        }
                        if (label == null || label.length() <= 0) {
                            label = "" + index;
                        }
                        if (!this.excludePoint(label, index)) {
                            PlotPoint point = new PlotPoint(yvalue, this.getUrl(label, index), label);
                            if (LOGGER.isLoggable(defaultLogLevel)) {
                                LOGGER.log(defaultLogLevel, "CSV Point: [" + index + ":" + lineNum + "]" + point);
                            }
                            ret.add(point);
                            continue;
                        }
                        if (!LOGGER.isLoggable(defaultLogLevel)) continue;
                        LOGGER.log(defaultLogLevel, "excluded CSV Column: " + index + " : " + label);
                    }
                    ++lineNum;
                }
                plotPointArray = ret.toArray(new PlotPoint[ret.size()]);
            }
            catch (IOException ioe) {
                if (LOGGER.isLoggable(defaultLogLevel)) {
                    LOGGER.log(defaultLogLevel, "Exception: " + ioe);
                }
                break block67;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignore) {}
                }
                if (inputReader != null) {
                    try {
                        inputReader.close();
                    }
                    catch (IOException ignore) {}
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            return plotPointArray;
        }
        return null;
    }

    private boolean excludePoint(String label, int index) {
        if (this.inclusionFlag == null || this.inclusionFlag == InclusionFlag.OFF) {
            return false;
        }
        boolean retVal = false;
        switch (1.$SwitchMap$hudson$plugins$plot$CSVSeries$InclusionFlag[this.inclusionFlag.ordinal()]) {
            case 1: {
                retVal = !this.strExclusionSet.contains(label);
                break;
            }
            case 2: {
                retVal = this.strExclusionSet.contains(label);
                break;
            }
            case 3: {
                retVal = !this.colExclusionSet.contains(index);
                break;
            }
            case 4: {
                retVal = this.colExclusionSet.contains(index);
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest((retVal ? "excluded" : "included") + " CSV Column: " + index + " : " + label);
        }
        return retVal;
    }

    private void loadExclusionSet() {
        if (this.inclusionFlag == InclusionFlag.OFF) {
            return;
        }
        if (this.exclusionValues == null) {
            this.inclusionFlag = InclusionFlag.OFF;
            return;
        }
        switch (1.$SwitchMap$hudson$plugins$plot$CSVSeries$InclusionFlag[this.inclusionFlag.ordinal()]) {
            case 1: 
            case 2: {
                this.strExclusionSet = new HashSet();
                break;
            }
            case 3: 
            case 4: {
                this.colExclusionSet = new HashSet();
            }
        }
        block10: for (String str : PAT_COMMA.split(this.exclusionValues)) {
            if (str == null || str.length() <= 0) continue;
            switch (1.$SwitchMap$hudson$plugins$plot$CSVSeries$InclusionFlag[this.inclusionFlag.ordinal()]) {
                case 1: 
                case 2: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest(this.inclusionFlag + " CSV Column: " + str);
                    }
                    this.strExclusionSet.add(str);
                    continue block10;
                }
                case 3: 
                case 4: {
                    try {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest(this.inclusionFlag + " CSV Column: " + str);
                        }
                        this.colExclusionSet.add(Integer.valueOf(str));
                        continue block10;
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private String getUrl(String label, int index) {
        Matcher indexMatcher;
        Matcher nameMatcher = PAT_NAME.matcher(label);
        if (nameMatcher.find()) {
            this.url = nameMatcher.replaceAll(label);
        }
        if ((indexMatcher = PAT_INDEX.matcher(label)).find()) {
            this.url = indexMatcher.replaceAll(label);
        }
        return this.url;
    }
}

