/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import hudson.model.Action;
import hudson.model.Project;
import hudson.plugins.plot.PlotPublisher;
import hudson.plugins.plot.PlotReport;
import java.io.IOException;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class PlotAction
implements Action,
StaplerProxy {
    private static final Logger LOGGER = Logger.getLogger(PlotAction.class.getName());
    private final Project project;
    private final PlotPublisher publisher;

    public PlotAction(Project project, PlotPublisher publisher) {
        this.project = project;
        this.publisher = publisher;
    }

    public Project getProject() {
        return this.project;
    }

    public String getDisplayName() {
        return "Plots";
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return "plot";
    }

    public boolean hasPlots() throws IOException {
        return this.publisher.getPlots().length != 0;
    }

    public String[] getOriginalGroups() {
        return this.publisher.getOriginalGroups();
    }

    public String getUrlGroup(String originalGroup) {
        return this.publisher.originalGroupToUrlEncodedGroup(originalGroup);
    }

    public PlotReport getDynamic(String group, StaplerRequest req, StaplerResponse rsp) throws IOException {
        return new PlotReport(this.project, this.publisher.urlGroupToOriginalGroup(group), this.publisher.getPlots(group));
    }

    public Object getTarget() {
        String[] groups = this.getOriginalGroups();
        if (groups != null && groups.length == 1) {
            return new PlotReport(this.project, groups[0], this.publisher.getPlots(this.getUrlGroup(groups[0])));
        }
        return this;
    }
}

