/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.plugins.plot.Plot;
import hudson.plugins.plot.PlotAction;
import hudson.plugins.plot.SeriesFactory;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotPublisher
extends Recorder {
    private static final Logger LOGGER = Logger.getLogger(PlotPublisher.class.getName());
    private ArrayList<Plot> plots = new ArrayList();
    private transient HashMap<String, ArrayList<Plot>> groupMap = new HashMap();
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    private Object readResolve() {
        Plot[] p = this.plots.toArray(new Plot[0]);
        this.setPlots(p);
        return this;
    }

    public String urlGroupToOriginalGroup(String urlGroup) {
        ArrayList<Plot> plots;
        if (urlGroup == null || "nogroup".equals(urlGroup)) {
            return "Plots";
        }
        if (this.groupMap.containsKey(urlGroup) && (plots = this.groupMap.get(urlGroup)).size() > 0) {
            return plots.get((int)0).group;
        }
        return "";
    }

    public String originalGroupToUrlEncodedGroup(String originalGroup) {
        return Util.rawEncode((String)this.originalGroupToUrlGroup(originalGroup));
    }

    private String originalGroupToUrlGroup(String originalGroup) {
        if (originalGroup == null || "".equals(originalGroup)) {
            return "nogroup";
        }
        return originalGroup.replace('/', ' ');
    }

    public String[] getOriginalGroups() {
        ArrayList<String> originalGroups = new ArrayList<String>();
        for (String urlGroup : this.groupMap.keySet()) {
            originalGroups.add(this.urlGroupToOriginalGroup(urlGroup));
        }
        Object[] retVal = originalGroups.toArray(new String[0]);
        Arrays.sort(retVal);
        return retVal;
    }

    public void setPlots(Plot[] plots) {
        this.plots = new ArrayList();
        this.groupMap = new HashMap();
        for (Plot plot : plots) {
            this.addPlot(plot);
        }
    }

    public void addPlot(Plot plot) {
        this.plots.add(plot);
        String urlGroup = this.originalGroupToUrlGroup(plot.getGroup());
        if (this.groupMap.containsKey(urlGroup)) {
            ArrayList<Plot> list = this.groupMap.get(urlGroup);
            list.add(plot);
        } else {
            ArrayList<Plot> list = new ArrayList<Plot>();
            list.add(plot);
            this.groupMap.put(urlGroup, list);
        }
    }

    public Plot[] getPlots() {
        return this.plots.toArray(new Plot[0]);
    }

    public Plot[] getPlots(String urlGroup) {
        ArrayList<Plot> p = this.groupMap.get(urlGroup);
        if (p != null) {
            return p.toArray(new Plot[0]);
        }
        return new Plot[0];
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return project instanceof Project ? new PlotAction((Project)project, this) : null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (!(build instanceof Build)) {
            return true;
        }
        listener.getLogger().println("Recording plot data");
        for (Plot plot : this.getPlots()) {
            plot.addBuild((Build)build, listener.getLogger());
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(PlotPublisher.class);
        }

        public String getDisplayName() {
            return "Plot build data";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return Project.class.isAssignableFrom(jobType);
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            PlotPublisher publisher = new PlotPublisher();
            for (Object data : SeriesFactory.getArray(formData.get("plots"))) {
                publisher.addPlot(DescriptorImpl.bindPlot((JSONObject)data, req));
            }
            return publisher;
        }

        private static Plot bindPlot(JSONObject data, StaplerRequest req) {
            Plot p = (Plot)req.bindJSON(Plot.class, data);
            p.series = SeriesFactory.createSeriesList(data.get("series"), req);
            return p;
        }

        public FormValidation doCheckSeriesFile(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }
    }
}

