/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd.parser;

import hudson.FilePath;
import hudson.plugins.pmd.Messages;
import hudson.plugins.pmd.parser.PmdParser;
import hudson.plugins.pmd.util.model.JavaProject;
import hudson.plugins.pmd.util.model.MavenModule;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class PmdCollector
implements FilePath.FileCallable<JavaProject> {
    private static final String SLASH = "/";
    private static final long serialVersionUID = -6415863872891783891L;
    private static final boolean SKIP_OLD_FILES = false;
    private transient PrintStream logger;
    private final long buildTime;
    private final String filePattern;

    public PmdCollector(PrintStream listener, long buildTime, String filePattern) {
        this.logger = listener;
        this.buildTime = buildTime;
        this.filePattern = filePattern;
    }

    public JavaProject invoke(File workspace, VirtualChannel channel) throws IOException {
        String[] pmdFiles = this.findPmdFiles(workspace);
        JavaProject project = new JavaProject();
        if (pmdFiles.length == 0) {
            project.setError("No pmd report files were found. Configuration error?");
            return project;
        }
        try {
            for (String file : pmdFiles) {
                String message;
                File pmdFile = new File(workspace, file);
                String moduleName = PmdCollector.guessModuleName((String)pmdFile.getAbsolutePath());
                MavenModule module = new MavenModule(moduleName);
                if (!pmdFile.canRead()) {
                    message = Messages.PMD_PMDCollector_Error_NoPermission((Object)pmdFile);
                    this.getLogger().println(message);
                    module.setError(message);
                    continue;
                }
                if (new FilePath(pmdFile).length() <= 0L) {
                    message = Messages.PMD_PMDCollector_Error_EmptyFile((Object)pmdFile);
                    this.getLogger().println(message);
                    module.setError(message);
                    continue;
                }
                module = this.parseFile(workspace, pmdFile, module);
                project.addModule(module);
            }
        }
        catch (InterruptedException exception) {
            this.getLogger().println("Parsing has been canceled.");
        }
        return project;
    }

    private MavenModule parseFile(File workspace, File pmdFile, MavenModule emptyModule) throws InterruptedException {
        Exception exception = null;
        MavenModule module = emptyModule;
        try {
            FilePath filePath = new FilePath(pmdFile);
            PmdParser pmdParser = new PmdParser();
            module = pmdParser.parse(filePath.read(), emptyModule.getName());
            this.getLogger().println("Successfully parsed PMD file " + pmdFile + " of module " + module.getName() + " with " + module.getNumberOfAnnotations() + " warnings.");
        }
        catch (IOException e) {
            exception = e;
        }
        catch (SAXException e) {
            exception = e;
        }
        if (exception != null) {
            String errorMessage = Messages.PMD_PMDCollector_Error_Exception((Object)pmdFile) + "\n\n" + ExceptionUtils.getStackTrace((Throwable)exception);
            this.getLogger().println(errorMessage);
            module.setError(errorMessage);
        }
        return module;
    }

    public static String guessModuleName(String fileName) {
        String separator = fileName.contains("/") ? "/" : "\\";
        String path = StringUtils.substringBefore((String)fileName, (String)(separator + "target"));
        if (fileName.equals(path)) {
            return "";
        }
        if (path.contains(separator)) {
            return StringUtils.substringAfterLast((String)path, (String)separator);
        }
        return path;
    }

    private String[] findPmdFiles(File workspaceRoot) {
        FileSet fileSet = new FileSet();
        Project project = new Project();
        fileSet.setProject(project);
        fileSet.setDir(workspaceRoot);
        fileSet.setIncludes(this.filePattern);
        return fileSet.getDirectoryScanner(project).getIncludedFiles();
    }

    private PrintStream getLogger() {
        if (this.logger == null) {
            this.logger = System.out;
        }
        return this.logger;
    }
}

