/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd.util;

import hudson.plugins.pmd.util.HealthReportBuilder;
import hudson.tasks.Publisher;
import org.apache.commons.lang.StringUtils;

public abstract class HealthAwarePublisher
extends Publisher {
    private final String pattern;
    private final String threshold;
    private boolean thresholdEnabled;
    private int minimumAnnotations;
    private final String healthy;
    private final String unHealthy;
    private int healthyAnnotations;
    private int unHealthyAnnotations;
    private boolean healthyReportEnabled;

    public HealthAwarePublisher(String pattern, String threshold, String healthy, String unHealthy) {
        this.threshold = threshold;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.pattern = pattern;
        if (!StringUtils.isEmpty((String)threshold)) {
            try {
                this.minimumAnnotations = Integer.valueOf(threshold);
                if (this.minimumAnnotations >= 0) {
                    this.thresholdEnabled = true;
                }
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)healthy) && !StringUtils.isEmpty((String)unHealthy)) {
            try {
                this.healthyAnnotations = Integer.valueOf(healthy);
                this.unHealthyAnnotations = Integer.valueOf(unHealthy);
                if (this.healthyAnnotations >= 0 && this.unHealthyAnnotations > this.healthyAnnotations) {
                    this.healthyReportEnabled = true;
                }
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
        }
    }

    protected HealthReportBuilder createHealthReporter(String reportSingleCount, String reportMultipleCount) {
        return new HealthReportBuilder(this.thresholdEnabled, this.minimumAnnotations, this.healthyReportEnabled, this.healthyAnnotations, this.unHealthyAnnotations, reportSingleCount, reportMultipleCount);
    }

    public boolean isThresholdEnabled() {
        return this.thresholdEnabled;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public int getMinimumAnnotations() {
        return this.minimumAnnotations;
    }

    public boolean isHealthyReportEnabled() {
        return this.healthyReportEnabled;
    }

    public String getHealthy() {
        return this.healthy;
    }

    public int getHealthyAnnotations() {
        return this.healthyAnnotations;
    }

    public String getUnHealthy() {
        return this.unHealthy;
    }

    public int getUnHealthyAnnotations() {
        return this.unHealthyAnnotations;
    }

    public String getPattern() {
        return this.pattern;
    }
}

